/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.decorators;

import eu.geclipse.core.jobs.GridJob;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridJobStatus;
import eu.geclipse.ui.internal.Activator;
import java.net.URL;
import java.util.Hashtable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;

public class GridJobDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    private static final String ID = "eu.geclipse.ui.gridJobDecorator";
    private static final String STATUS_UNKNOWN_IMG = "status_unknown.gif";
    private static final String STATUS_SUBMITTED_IMG = "status_submitted.gif";
    private static final String STATUS_WAITING_IMG = "status_waiting.gif";
    private static final String STATUS_RUNNING_IMG = "status_running.gif";
    private static final String STATUS_DONE_IMG = "status_done.gif";
    private static final String STATUS_ABORTED_IMG = "status_aborted.gif";
    private static final String STATUS_ABANDONED_IMG = "status_abandoned.gif";
    private static Hashtable<Integer, String> imageNames = new Hashtable();

    static {
        imageNames.put(128, STATUS_UNKNOWN_IMG);
        imageNames.put(1, STATUS_SUBMITTED_IMG);
        imageNames.put(2, STATUS_WAITING_IMG);
        imageNames.put(4, STATUS_RUNNING_IMG);
        imageNames.put(8, STATUS_DONE_IMG);
        imageNames.put(16, STATUS_ABORTED_IMG);
        imageNames.put(32, STATUS_ABANDONED_IMG);
    }

    public static GridJobDecorator getDecorator() {
        GridJobDecorator result = null;
        IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
        if (decoratorManager.getEnabled(ID)) {
            result = (GridJobDecorator)decoratorManager.getBaseLabelProvider(ID);
        }
        return result;
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof GridJob) {
            IGridJobStatus status = ((GridJob)element).getJobStatus();
            ImageDescriptor decorator = this.getIcon(status.getType());
            decoration.addOverlay(decorator, 2);
        }
    }

    public void refresh(IGridElement toUpdate) {
        LabelProviderChangedEvent event = toUpdate == null ? new LabelProviderChangedEvent((IBaseLabelProvider)GridJobDecorator.getDecorator()) : new LabelProviderChangedEvent((IBaseLabelProvider)GridJobDecorator.getDecorator(), (Object)toUpdate);
        this.fireLabelProviderChanged(event);
    }

    public void refresh(IGridElement[] toUpdate) {
        LabelProviderChangedEvent event = toUpdate == null || toUpdate.length == 0 ? new LabelProviderChangedEvent((IBaseLabelProvider)GridJobDecorator.getDecorator()) : new LabelProviderChangedEvent((IBaseLabelProvider)GridJobDecorator.getDecorator(), (Object[])toUpdate);
        this.fireLabelProviderChanged(event);
    }

    private ImageDescriptor getIcon(int type) {
        ImageDescriptor decorator = null;
        String fileName = imageNames.get(type);
        if (fileName == null) {
            fileName = imageNames.get(Integer.valueOf(STATUS_UNKNOWN_IMG));
        }
        URL imgUrl = Activator.getDefault().getBundle().getEntry("icons/ovr16/" + fileName);
        decorator = ImageDescriptor.createFromURL((URL)imgUrl);
        return decorator;
    }
}

