/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.decorators;

import eu.geclipse.core.ExtensionManager;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.ui.internal.Activator;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class GridProjectFolderDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    private static final String ID = "eu.geclipse.ui.gridProjectFolderDecorator";
    private Hashtable<String, ImageDescriptor> images = new Hashtable();

    public static GridProjectFolderDecorator getDecorator() {
        GridProjectFolderDecorator result = null;
        IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
        if (decoratorManager.getEnabled(ID)) {
            result = (GridProjectFolderDecorator)decoratorManager.getBaseLabelProvider(ID);
        }
        return result;
    }

    public GridProjectFolderDecorator() {
        ImageDescriptor standardImage = null;
        ImageDescriptor image = null;
        ExtensionManager extm = new ExtensionManager();
        List configurationElements = extm.getConfigurationElements("eu.geclipse.core.gridProjectFolder", "folder");
        for (IConfigurationElement element : configurationElements) {
            String id = element.getAttribute("id");
            String icon = element.getAttribute("icon");
            if (icon != null) {
                IExtension extension = element.getDeclaringExtension();
                IContributor contributor = extension.getContributor();
                String name = contributor.getName();
                Bundle bundle = Platform.getBundle((String)name);
                URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(icon), null);
                image = ImageDescriptor.createFromURL((URL)url);
            } else {
                if (standardImage == null) {
                    URL url = Activator.getDefault().getBundle().getEntry("icons/ovr16/project_ovr.gif");
                    standardImage = ImageDescriptor.createFromURL((URL)url);
                }
                image = standardImage;
            }
            this.images.put(id, image);
        }
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IGridContainer) {
            this.decorate((IGridContainer)element, decoration);
        }
    }

    public void refresh(IGridElement toUpdate) {
        LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)GridProjectFolderDecorator.getDecorator(), (Object)toUpdate);
        this.fireLabelProviderChanged(event);
    }

    public void refresh(IGridElement[] toUpdate) {
        LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)GridProjectFolderDecorator.getDecorator(), (Object[])toUpdate);
        this.fireLabelProviderChanged(event);
    }

    private void decorate(IGridContainer container, IDecoration decoration) {
        ImageDescriptor image;
        String id;
        IGridContainer parent = container.getParent();
        if (parent instanceof IGridProject && (id = ((IGridProject)parent).getProjectFolderID(container)) != null && (image = this.images.get(id)) != null) {
            decoration.addOverlay(image, 1);
        }
    }
}

