/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.dialogs;

import eu.geclipse.core.accesscontrol.IACL;
import eu.geclipse.core.accesscontrol.IACLEntry;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.comparators.TableColumnComparator;
import eu.geclipse.ui.dialogs.AccessControlRuleDialog;
import eu.geclipse.ui.dialogs.Messages;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.listeners.TableColumnListener;
import eu.geclipse.ui.providers.ACLEntryLabelProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessControlDialog
extends Dialog {
    boolean canSaveWholeACL;
    List<IACL> aclList;
    private List<IACLEntry> entriesList;
    private TableViewer tableViewer;

    public AccessControlDialog(List<IACL> acls, boolean canSaveWholeACL, Shell parentShell) {
        super(parentShell);
        this.setShellStyle(68848);
        this.canSaveWholeACL = canSaveWholeACL;
        this.aclList = acls;
        this.entriesList = new ArrayList<IACLEntry>();
    }

    public Control createDialogArea(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(1, false));
        GridData gData = new GridData(4, 4, true, true);
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        mainComp.setLayoutData((Object)gData);
        Group aclGroup = new Group(mainComp, 0);
        aclGroup.setLayout((Layout)new GridLayout(2, false));
        aclGroup.setText(Messages.getString("AccessControlDialog.group_title"));
        gData = new GridData(4, 4, true, true);
        gData.heightHint = 200;
        aclGroup.setLayoutData((Object)gData);
        int style = 2820;
        Table aclEntriesTable = new Table((Composite)aclGroup, style);
        gData = new GridData(4, 4, true, true);
        aclEntriesTable.setLayoutData((Object)gData);
        aclEntriesTable.setHeaderVisible(true);
        TableColumn policyColumn = new TableColumn(aclEntriesTable, 16384);
        policyColumn.setText(Messages.getString("AccessControlDialog.policy_column_title"));
        policyColumn.setToolTipText(Messages.getString("AccessControlDialog.policy_tooltip"));
        policyColumn.setWidth(120);
        policyColumn.setAlignment(16384);
        TableColumn capabilityColumn = new TableColumn(aclEntriesTable, 16384);
        capabilityColumn.setText(Messages.getString("AccessControlDialog.capability_column_title"));
        capabilityColumn.setToolTipText(Messages.getString("AccessControlDialog.capability_tooltip"));
        capabilityColumn.setWidth(100);
        capabilityColumn.setAlignment(16384);
        TableColumn actorTypeColumn = new TableColumn(aclEntriesTable, 16384);
        actorTypeColumn.setText(Messages.getString("AccessControlDialog.actor_type_column_title"));
        actorTypeColumn.setToolTipText(Messages.getString("AccessControlDialog.actor_type_tooltip"));
        actorTypeColumn.setWidth(130);
        actorTypeColumn.setAlignment(16384);
        TableColumn actorIDColumn = new TableColumn(aclEntriesTable, 16384);
        actorIDColumn.setText(Messages.getString("AccessControlDialog.actor_ID_column_title"));
        actorIDColumn.setToolTipText(Messages.getString("AccessControlDialog.actor_ID_tooltip"));
        actorIDColumn.setWidth(300);
        actorIDColumn.setAlignment(16384);
        TableColumn actorCAColumn = new TableColumn(aclEntriesTable, 16384);
        actorCAColumn.setText(Messages.getString("AccessControlDialog.actor_CA_column_title"));
        actorCAColumn.setToolTipText(Messages.getString("AccessControlDialog.actor_CA_tooltip"));
        actorCAColumn.setWidth(150);
        actorCAColumn.setAlignment(16384);
        this.tableViewer = new TableViewer(aclEntriesTable);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ACLEntryLabelProvider());
        TableColumnListener columnListener = new TableColumnListener(this.tableViewer);
        TableColumn[] tableColumnArray = aclEntriesTable.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.addSelectionListener((SelectionListener)columnListener);
            ++n2;
        }
        aclEntriesTable.setSortColumn(capabilityColumn);
        aclEntriesTable.setSortDirection(128);
        this.tableViewer.setComparator((ViewerComparator)new TableColumnComparator(capabilityColumn));
        Composite buttons = new Composite((Composite)aclGroup, 0);
        gData = new GridData(0x1000000, 1, false, false);
        gData.horizontalSpan = 1;
        buttons.setLayoutData((Object)gData);
        GridLayout gLayout = new GridLayout(1, false);
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        buttons.setLayout((Layout)gLayout);
        Button addEntryButton = new Button(buttons, 8);
        addEntryButton.setText(Messages.getString("AccessControlDialog.add_button_text"));
        gData = new GridData(768);
        addEntryButton.setLayoutData((Object)gData);
        addEntryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IACLEntry newEntry = AccessControlDialog.this.aclList.get(0).getEmptyEntry();
                AccessControlDialog.this.editEntry(newEntry);
            }
        });
        Button editEntryButton = new Button(buttons, 8);
        editEntryButton.setText(Messages.getString("AccessControlDialog.edit_button_text"));
        gData = new GridData(768);
        editEntryButton.setLayoutData((Object)gData);
        editEntryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccessControlDialog.this.editEntry(AccessControlDialog.this.getSelectedEntry());
            }
        });
        Button removeEntryButton = new Button(buttons, 8);
        removeEntryButton.setText(Messages.getString("AccessControlDialog.remove_button_text"));
        gData = new GridData(768);
        removeEntryButton.setLayoutData((Object)gData);
        removeEntryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccessControlDialog.this.removeEntry();
            }
        });
        this.initialize();
        if (this.entriesList != null) {
            this.tableViewer.setInput(this.entriesList);
        }
        return mainComp;
    }

    private void initialize() {
        IACL acl = this.aclList.get(0);
        if (acl != null) {
            try {
                IACLEntry[] iACLEntryArray = acl.getEntries(null);
                int n = iACLEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IACLEntry entry = iACLEntryArray[n2];
                    this.entriesList.add(entry);
                    ++n2;
                }
            }
            catch (ProblemException problemException) {}
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("AccessControlDialog.dialog_title"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        String buttonText = null;
        buttonText = this.canSaveWholeACL ? Messages.getString("AccessControlDialog.save_button_text") : Messages.getString("AccessControlDialog.done_button_text");
        this.createButton(parent, 0, buttonText, true);
        if (this.canSaveWholeACL) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    IACLEntry getSelectedEntry() {
        IACLEntry entry = null;
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        Object obj = selection.getFirstElement();
        if (obj instanceof IACLEntry) {
            entry = (IACLEntry)obj;
        }
        return entry;
    }

    void editEntry(IACLEntry entry) {
        AccessControlRuleDialog dialog = new AccessControlRuleDialog(entry, !this.canSaveWholeACL, this.getShell());
        int result = dialog.open();
        switch (result) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
        }
    }

    void removeEntry() {
        boolean confirm = true;
        if (!this.canSaveWholeACL) {
            confirm = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Remove rule", (String)"You are going to remove this access control rule. Continue?");
        }
        if (confirm) {
            IACLEntry entry = this.getSelectedEntry();
            try {
                for (IACL acl : this.aclList) {
                    acl.removeEntry(entry, null);
                }
                this.entriesList.remove(entry);
            }
            catch (ProblemException pe) {
                ProblemDialog.openProblem(this.getShell(), "Error deleting rule", "The selected rule could not be deleted", pe);
            }
        }
    }
}

