/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.dialogs;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridService;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.widgets.StoredCombo;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ServiceDialog
extends TitleAreaDialog {
    private static String SERVICE_URI_ID = "vo_service_uri";
    private Combo typeCombo;
    private StoredCombo uriCombo;
    private Hashtable<String, IConfigurationElement> configs;
    private URI selectedURI;
    private IConfigurationElement selectedElement;

    public ServiceDialog(Shell parentShell) {
        super(parentShell);
        URL imgURL = Activator.getDefault().getBundle().getEntry("icons/wizban/service_wiz.gif");
        this.setTitleImage(ImageDescriptor.createFromURL((URL)imgURL).createImage());
    }

    public IConfigurationElement getSelectedElement() {
        return this.selectedElement;
    }

    public URI getSelectedURI() {
        return this.selectedURI;
    }

    protected void okPressed() {
        try {
            this.selectedElement = this.configs.get(this.typeCombo.getText());
            this.selectedURI = new URI(this.uriCombo.getText());
            if (this.selectedURI.getScheme() == null || this.selectedURI.getPort() == -1) {
                this.setErrorMessage("Please specify a full URI for the service (including scheme and port)");
            } else {
                super.okPressed();
            }
        }
        catch (Exception exc) {
            this.setErrorMessage(exc.getLocalizedMessage());
        }
    }

    protected Control createDialogArea(Composite parent) {
        IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
        Composite mainComp = (Composite)super.createDialogArea(parent);
        mainComp.setLayout((Layout)new GridLayout(1, false));
        this.getShell().setText("Add service");
        Label typeLabel = new Label(mainComp, 0);
        typeLabel.setText("Service &Type:");
        GridData gData = new GridData();
        typeLabel.setLayoutData((Object)gData);
        this.typeCombo = new Combo(mainComp, 8);
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        this.typeCombo.setLayoutData((Object)gData);
        Label urlLabel = new Label(mainComp, 0);
        urlLabel.setText("Service &URI:");
        gData = new GridData();
        urlLabel.setLayoutData((Object)gData);
        this.uriCombo = new StoredCombo(mainComp, 0);
        this.uriCombo.setPreferences(prefStore, SERVICE_URI_ID);
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        this.uriCombo.setLayoutData(gData);
        this.setTitle("Add service");
        this.setMessage("Specify a service to be added to your VO.");
        this.initServiceTypeCombo();
        return mainComp;
    }

    private void initServiceTypeCombo() {
        List elements = GridModel.getCreatorRegistry().getConfigurations(URI.class, IGridService.class);
        this.configs = new Hashtable();
        for (IConfigurationElement element : elements) {
            String name = element.getAttribute("name");
            this.configs.put(name, element);
        }
        Object[] names = this.configs.keySet().toArray(new String[this.configs.size()]);
        Arrays.sort(names);
        this.typeCombo.setItems((String[])names);
        if (names.length > 0) {
            this.typeCombo.setText((String)names[0]);
        }
    }
}

