/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal;

import eu.geclipse.core.security.ICertificateTrustVerifier;
import eu.geclipse.ui.internal.dialogs.CertificateTrustDialog;
import java.security.cert.X509Certificate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class UICertificateTrustVerifier
implements ICertificateTrustVerifier {
    public ICertificateTrustVerifier.TrustMode verifyTrust(X509Certificate[] chain) {
        DialogRunnable runnable = new DialogRunnable(chain);
        Display.getDefault().syncExec((Runnable)runnable);
        return runnable.getResult();
    }

    private static class DialogRunnable
    implements Runnable {
        private X509Certificate[] chain;
        private ICertificateTrustVerifier.TrustMode result;

        public DialogRunnable(X509Certificate[] chain) {
            this.chain = chain;
        }

        public ICertificateTrustVerifier.TrustMode getResult() {
            return this.result;
        }

        public void run() {
            IWorkbench workbench;
            IWorkbenchWindow window;
            Display display = Display.getDefault();
            Shell shell = display.getActiveShell();
            if (shell == null && (window = (workbench = PlatformUI.getWorkbench()).getActiveWorkbenchWindow()) != null) {
                shell = window.getShell();
            }
            this.result = CertificateTrustDialog.openDialog(shell, this.chain);
        }
    }
}

