/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.actions.Messages;
import eu.geclipse.ui.views.filters.GridFilterConfigurationsManager;
import eu.geclipse.ui.views.filters.IFilterConfigurationListener;
import eu.geclipse.ui.views.filters.IGridFilterConfiguration;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchSite;

public class ConfigureFiltersAction
extends Action {
    private static final String CONFIGURE_IMG = "configure_filters";
    private static final String CONFIGURE_IMG_ON = "configure_filters_on";
    protected MenuCreator menuCreator;
    protected GridFilterConfigurationsManager filterConfigurationsManager;
    private IWorkbenchSite site;
    private IFilterConfigurationListener configurationListener;

    public ConfigureFiltersAction(IWorkbenchSite site, GridFilterConfigurationsManager filterConfigurationsManager) {
        super(Messages.getString("ConfigureFiltersAction.name"), 4);
        this.filterConfigurationsManager = filterConfigurationsManager;
        this.site = site;
        this.setImageDescriptor(Activator.getDefault().getImageRegistry().getDescriptor(CONFIGURE_IMG));
        this.setToolTipText(Messages.getString("ConfigureFiltersAction.description"));
        this.menuCreator = new MenuCreator();
        this.setMenuCreator(this.menuCreator);
        this.initImage();
    }

    public void run() {
        this.filterConfigurationsManager.configure(this.site.getShell());
    }

    protected void setImage(boolean filterOn) {
        this.setImageDescriptor(Activator.getDefault().getImageRegistry().getDescriptor(filterOn ? CONFIGURE_IMG_ON : CONFIGURE_IMG));
    }

    protected IFilterConfigurationListener getConfigurationListener() {
        if (this.configurationListener == null) {
            this.configurationListener = new IFilterConfigurationListener(){

                public void configurationChanged() {
                    ConfigureFiltersAction.this.menuCreator.disposeMenu();
                }

                public void filterConfigurationSelected(ViewerFilter[] filters) {
                    ConfigureFiltersAction.this.setImage(filters);
                }
            };
        }
        return this.configurationListener;
    }

    protected void setImage(ViewerFilter[] filters) {
        this.setImage(filters != null && filters.length > 0);
    }

    private void initImage() {
        if (this.filterConfigurationsManager != null) {
            this.setImage(this.filterConfigurationsManager.getEnabledFilters());
        } else {
            this.setImage(false);
        }
    }

    private class MenuCreator
    implements IMenuCreator {
        private Menu menu;

        protected MenuCreator() {
            ConfigureFiltersAction.this.filterConfigurationsManager.addConfigurationListener(ConfigureFiltersAction.this.getConfigurationListener());
        }

        public void dispose() {
            if (this.menu != null) {
                this.disposeMenu();
            }
            ConfigureFiltersAction.this.filterConfigurationsManager.removeConfigurationListener(ConfigureFiltersAction.this.getConfigurationListener());
        }

        public Menu getMenu(Control parent) {
            if (this.menu == null) {
                this.menu = this.createMenu(parent);
            }
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        protected void disposeMenu() {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = null;
        }

        private Menu createMenu(Control parent) {
            Menu rootMenu = new Menu(parent);
            for (IGridFilterConfiguration configuration : ConfigureFiltersAction.this.filterConfigurationsManager.getConfigurations()) {
                this.createMenuItem(rootMenu, configuration);
            }
            if (!ConfigureFiltersAction.this.filterConfigurationsManager.getConfigurations().isEmpty()) {
                new MenuItem(rootMenu, 2);
            }
            this.createConfigureMenu(rootMenu);
            return rootMenu;
        }

        private void createConfigureMenu(Menu parent) {
            MenuItem item = new MenuItem(parent, 64);
            item.setText(Messages.getString("ConfigureFiltersAction.ConfigureFilters"));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConfigureFiltersAction.this.run();
                }
            });
        }

        private void createMenuItem(Menu parent, IGridFilterConfiguration configuration) {
            MenuItem item = new MenuItem(parent, 16);
            item.setText(configuration.getName());
            item.setSelection(configuration.isEnabled());
            item.addSelectionListener((SelectionListener)new MenuItemSelectionListener(configuration));
        }
    }

    private class MenuItemSelectionListener
    extends SelectionAdapter {
        private IGridFilterConfiguration configuration;

        protected MenuItemSelectionListener(IGridFilterConfiguration configuration) {
            this.configuration = configuration;
        }

        public void widgetSelected(SelectionEvent event) {
            MenuItem menuItem = (MenuItem)event.getSource();
            if (menuItem != null && menuItem.getSelection()) {
                ConfigureFiltersAction.this.filterConfigurationsManager.enableConfiguration(this.configuration);
            }
        }
    }
}

