/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.ui.internal.actions.CopyAction;
import eu.geclipse.ui.internal.actions.DeleteGridElementAction;
import eu.geclipse.ui.internal.actions.PasteAction;
import eu.geclipse.ui.views.GridModelViewPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.RenameResourceAction;

public class FileActions
extends ActionGroup {
    private Clipboard clipboard;
    private IWorkbenchSite site;
    private CopyAction copyAction;
    private PasteAction pasteAction;
    private DeleteGridElementAction deleteElementAction;
    private RenameResourceAction renameAction;

    public FileActions(GridModelViewPart view) {
        this.site = view.getSite();
        Shell shell = this.site.getShell();
        ISelectionProvider provider = this.site.getSelectionProvider();
        this.clipboard = new Clipboard(shell.getDisplay());
        this.copyAction = new CopyAction(this.clipboard);
        this.pasteAction = new PasteAction(this.clipboard);
        this.deleteElementAction = new DeleteGridElementAction(shell);
        this.renameAction = new RenameResourceAction(shell);
        provider.addSelectionChangedListener((ISelectionChangedListener)this.copyAction);
        provider.addSelectionChangedListener((ISelectionChangedListener)this.pasteAction);
        provider.addSelectionChangedListener((ISelectionChangedListener)this.deleteElementAction);
        provider.addSelectionChangedListener((ISelectionChangedListener)this.renameAction);
        ISelection selection = provider.getSelection();
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            selection = StructuredSelection.EMPTY;
        }
        this.copyAction.selectionChanged((IStructuredSelection)selection);
        this.pasteAction.selectionChanged((IStructuredSelection)selection);
        this.deleteElementAction.selectionChanged((IStructuredSelection)selection);
        this.renameAction.selectionChanged((IStructuredSelection)selection);
    }

    public void dispose() {
        ISelectionProvider provider = this.site.getSelectionProvider();
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.copyAction);
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.pasteAction);
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.deleteElementAction);
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.renameAction);
        this.clipboard.dispose();
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.deleteElementAction.isEnabled()) {
            menu.appendToGroup("group.edit", (IAction)this.copyAction);
            menu.appendToGroup("group.edit", (IAction)this.pasteAction);
            menu.appendToGroup("group.edit", (IAction)this.deleteElementAction);
            menu.appendToGroup("group.edit", (IAction)this.renameAction);
        }
        super.fillContextMenu(menu);
    }

    public void updateActionBars() {
        super.updateActionBars();
        IStructuredSelection selection = null;
        if (this.getContext() != null && this.getContext().getSelection() instanceof IStructuredSelection) {
            selection = (IStructuredSelection)this.getContext().getSelection();
        }
        this.copyAction.selectionChanged(selection);
        this.pasteAction.selectionChanged(selection);
        this.deleteElementAction.selectionChanged(selection);
        this.renameAction.selectionChanged(selection);
    }
}

