/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.ui.internal.actions.Messages;
import eu.geclipse.ui.internal.actions.OpenElementAction;
import eu.geclipse.ui.views.GridModelViewPart;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.OpenWithMenu;

public class OpenActions
extends ActionGroup {
    protected OpenElementAction openElementAction;
    protected OpenWithMenu openWithMenu;
    private IWorkbenchSite site;

    public OpenActions(GridModelViewPart part) {
        this.site = part.getSite();
        this.site.getPage();
        ISelectionProvider provider = this.site.getSelectionProvider();
        this.openElementAction = new OpenElementAction(this.site);
        provider.addSelectionChangedListener((ISelectionChangedListener)this.openElementAction);
        part.getViewer().getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000C) {
                    OpenActions.this.openElementAction.run();
                }
            }
        });
    }

    public void dispose() {
        ISelectionProvider provider = this.site.getSelectionProvider();
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.openElementAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.openElementAction.isEnabled()) {
            menu.appendToGroup("group.open", (IAction)this.openElementAction);
            IAdaptable adaptable = this.getSelectedAdaptable();
            if (adaptable != null) {
                OpenWithMenu openWith = new OpenWithMenu(this.site.getPage(), adaptable);
                MenuManager subMenu = new MenuManager(Messages.getString("OpenActions.open_with_menu_label"));
                menu.appendToGroup("group.open", (IContributionItem)subMenu);
                subMenu.add((IContributionItem)openWith);
            }
        }
        super.fillContextMenu(menu);
    }

    public void delegateOpenEvent(OpenEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            Object element = sSelection.getFirstElement();
            if (!(element instanceof IResource) && element instanceof IAdaptable) {
                element = ((IAdaptable)element).getAdapter(IResource.class);
            }
            if (element instanceof IFile) {
                this.openElementAction.selectionChanged(sSelection);
                this.openElementAction.run();
            }
        }
    }

    public void updateActionBars() {
        super.updateActionBars();
        IStructuredSelection selection = null;
        if (this.getContext() != null && this.getContext().getSelection() instanceof IStructuredSelection) {
            selection = (IStructuredSelection)this.getContext().getSelection();
        }
        this.openElementAction.selectionChanged(selection);
    }

    private IAdaptable getSelectedAdaptable() {
        Object element;
        ISelection selection;
        IAdaptable result = null;
        ActionContext context = this.getContext();
        if (context != null && (selection = context.getSelection()) != null && selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            result = (IAdaptable)element;
        }
        return result;
    }
}

