/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.internal.actions.Messages;
import eu.geclipse.ui.internal.actions.OpenFileAction;
import eu.geclipse.ui.internal.actions.OpenJobAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class OpenElementAction
extends Action
implements ISelectionChangedListener {
    private OpenFileAction openFileAction;
    private OpenJobAction openJobAction;
    private BaseSelectionListenerAction activeAction;

    protected OpenElementAction(IWorkbenchSite site) {
        super(Messages.getString("OpenElementAction.open_element_action_text"));
        ISelection selection;
        IWorkbenchPage page = site.getPage();
        this.openFileAction = new OpenFileAction(page);
        this.openJobAction = new OpenJobAction(page);
        ISelectionProvider provider = site.getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
            this.selectionChanged((IStructuredSelection)selection);
        }
    }

    public void run() {
        if (this.activeAction != null) {
            try {
                this.activeAction.run();
            }
            catch (RuntimeException exc) {
                if (exc.getCause() instanceof ProblemException) {
                    ProblemException problemExc = (ProblemException)exc.getCause();
                    Shell shell = null;
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                    if (window != null) {
                        shell = window.getShell();
                    }
                    ProblemDialog.openProblem(shell, Messages.getString("OpenElementAction.problemDialogTitle"), Messages.getString("OpenElementAction.problemCannotOpen"), problemExc);
                }
                throw exc;
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.selectionChanged((IStructuredSelection)selection);
        } else {
            this.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.activeAction = null;
        if (selection != null) {
            if (this.isGridJob(selection)) {
                this.activeAction = this.openJobAction;
            } else if (!selection.isEmpty()) {
                this.activeAction = this.openFileAction;
            }
            if (this.activeAction != null) {
                this.activeAction.selectionChanged(selection);
                this.setEnabled(this.activeAction.isEnabled());
            } else {
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(false);
        }
    }

    protected boolean isGridConnection(IStructuredSelection selection) {
        return selection.size() == 1 && selection.getFirstElement() instanceof IGridConnectionElement;
    }

    protected boolean isGridJob(IStructuredSelection selection) {
        return selection.size() == 1 && selection.getFirstElement() instanceof IGridJob;
    }
}

