/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.internal.actions.Messages;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class OpenFileAction
extends SelectionListenerAction {
    private static long SIZE_LIMIT_MB = 10L;
    protected IWorkbenchPage workbenchPage;
    private IEditorDescriptor editorDescriptor;

    public OpenFileAction(IWorkbenchPage page) {
        this(page, null);
    }

    public OpenFileAction(IWorkbenchPage page, IEditorDescriptor descriptor) {
        super(Messages.getString("OpenFileAction.action_label"));
        this.workbenchPage = page;
        this.editorDescriptor = descriptor;
    }

    public void run() {
        for (Object next : this.getStructuredSelection()) {
            IResource resource;
            if (next instanceof IGridConnectionElement) {
                try {
                    this.openConnection((IGridConnectionElement)next);
                }
                catch (CoreException cExc) {
                    ProblemDialog.openProblem(this.workbenchPage.getWorkbenchWindow().getShell(), Messages.getString("OpenFileAction.open_failed_title"), String.format(Messages.getString("OpenFileAction.open_failed_text"), ((IGridConnectionElement)next).getName()), cExc);
                }
                continue;
            }
            if (!(next instanceof IAdaptable) || !((resource = (IResource)((IAdaptable)next).getAdapter(IResource.class)) instanceof IFile)) continue;
            this.openFile((IFile)resource);
        }
    }

    protected void openFile(IFile file) {
        try {
            boolean activate = OpenStrategy.activateOnOpen();
            if (this.editorDescriptor == null) {
                IDE.openEditor((IWorkbenchPage)this.workbenchPage, (IFile)file, (boolean)activate);
            } else {
                this.workbenchPage.openEditor((IEditorInput)new FileEditorInput(file), this.editorDescriptor.getId(), activate);
            }
        }
        catch (PartInitException piExc) {
            ProblemDialog.openProblem(this.workbenchPage.getWorkbenchWindow().getShell(), Messages.getString("OpenFileAction.open_failed_title"), String.format(Messages.getString("OpenFileAction.open_failed_text"), file.getName()), piExc);
        }
    }

    protected void openConnection(final IGridConnectionElement element) throws CoreException {
        boolean confirm = true;
        long lengthMB = element.getConnectionFileInfo().getLength() / 0x100000L;
        if (lengthMB > SIZE_LIMIT_MB) {
            confirm = MessageDialog.openConfirm((Shell)this.workbenchPage.getWorkbenchWindow().getShell(), (String)Messages.getString("OpenFileAction.open_confirm_title"), (String)String.format(Messages.getString("OpenFileAction.open_confirm_text"), lengthMB, SIZE_LIMIT_MB));
        }
        if (confirm) {
            Job job = new Job(String.format(Messages.getString("OpenFileAction.opening_progress"), element.getName())){

                protected IStatus run(IProgressMonitor monitor) {
                    SubMonitor sMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)String.format(Messages.getString("OpenFileAction.opening_progress"), element.getName()), (int)10);
                    try {
                        try {
                            sMonitor.subTask(Messages.getString("OpenFileAction.connecting_progress"));
                            IFileStore cfs = element.getCachedConnectionFileStore((IProgressMonitor)sMonitor.newChild(9));
                            sMonitor.subTask(Messages.getString("OpenFileAction.opening_editor_progress"));
                            try {
                                if (!sMonitor.isCanceled()) {
                                    OpenFileAction.this.workbenchPage.getWorkbenchWindow().getShell().getDisplay().syncExec(new Runnable(){

                                        public void run() {
                                            OpenFileAction.this.openFile((IFile)element.getResource());
                                        }
                                    });
                                    sMonitor.worked(1);
                                }
                            }
                            finally {
                                element.releaseCachedConnectionFileStore(cfs);
                            }
                        }
                        catch (CoreException cExc) {
                            this.showProblemDialog(cExc, element.getResource().getName());
                            sMonitor.done();
                        }
                    }
                    finally {
                        sMonitor.done();
                    }
                    return Status.OK_STATUS;
                }

                private void showProblemDialog(CoreException exc, String filename) {
                    Shell shell = OpenFileAction.this.workbenchPage.getWorkbenchWindow().getShell();
                    String msg = String.format("Problem occured during opening file ", filename);
                    ProblemDialog.openProblem(shell, "Cannot open file", msg, exc);
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }
}

