/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.core.model.IGridComputing;
import eu.geclipse.core.model.IGridResource;
import eu.geclipse.core.model.IGridService;
import eu.geclipse.core.model.IGridStorage;
import eu.geclipse.core.simpleTest.ISimpleTest;
import eu.geclipse.core.simpleTest.ISimpleTestDescription;
import eu.geclipse.ui.ISimpleTestUIFactory;
import eu.geclipse.ui.dialogs.AbstractSimpleTestDialog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.SelectionListenerAction;

public class SimpleTestAction
extends SelectionListenerAction {
    private List<IGridResource> resources;
    private ISimpleTestUIFactory factory;
    private IWorkbenchSite site;

    protected SimpleTestAction(IWorkbenchSite site, ISimpleTestUIFactory factory) {
        super(factory.getSupportedDescription().getSimpleTestTypeName());
        this.site = site;
        this.factory = factory;
    }

    public void run() {
        if (this.factory != null) {
            ISimpleTestDescription description = this.factory.getSupportedDescription();
            ISimpleTest test = description.createSimpleTest();
            AbstractSimpleTestDialog infoDialog = this.factory.getSimpleTestDialog(test, this.resources, this.site.getShell());
            infoDialog.open();
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.resources = new ArrayList<IGridResource>();
        boolean enabled = super.updateSelection(selection);
        Iterator iter = selection.iterator();
        while (iter.hasNext() && enabled) {
            Object element = iter.next();
            boolean isResource = this.isResourcePhysical(element);
            enabled &= isResource;
            if (!isResource) continue;
            this.resources.add((IGridResource)element);
        }
        return enabled && !this.resources.isEmpty();
    }

    protected boolean isResourcePhysical(Object element) {
        boolean ret = false;
        if (element instanceof IGridService || element instanceof IGridComputing || element instanceof IGridStorage) {
            ret = ((IGridResource)element).isVirtual();
        }
        return ret;
    }
}

