/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridJobDescription;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.actions.Messages;
import eu.geclipse.ui.wizards.jobsubmission.JobCreatorSelectionWizard;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.SelectionListenerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmitJobAction
extends SelectionListenerAction {
    private IWorkbenchSite site;
    private List<IGridJobDescription> jobDescriptions;

    protected SubmitJobAction(IWorkbenchSite site) {
        super(Messages.getString("SubmitJobAction.title"));
        this.site = site;
        this.jobDescriptions = new ArrayList<IGridJobDescription>();
    }

    public void run() {
        if (this.jobDescriptions.size() > 0) {
            JobCreatorSelectionWizard wizard = new JobCreatorSelectionWizard(this.jobDescriptions);
            WizardDialog dialog = new WizardDialog(this.site.getShell(), (IWizard)wizard);
            dialog.setBlockOnOpen(false);
            dialog.open();
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        boolean enabled;
        boolean bl = enabled = !selection.isEmpty() && super.updateSelection(selection);
        if (enabled) {
            this.jobDescriptions.clear();
            IGridProject project = null;
            Iterator iter = selection.iterator();
            while (iter.hasNext() && enabled) {
                Object element = iter.next();
                List<IGridJobDescription> descriptions = this.getJobDescriptions(element);
                if (descriptions != null && !descriptions.isEmpty()) {
                    if (project == null) {
                        project = descriptions.get(0).getProject();
                    }
                    if (project != descriptions.get(0).getProject()) {
                        return false;
                    }
                    this.jobDescriptions.addAll(descriptions);
                    continue;
                }
                enabled = false;
            }
        }
        return enabled && this.jobDescriptions != null;
    }

    private List<IGridJobDescription> getJobDescriptions(Object element) {
        IGridJobDescription jsdl;
        List<IGridJobDescription> descriptions = null;
        if (element instanceof IGridJobDescription) {
            descriptions = Collections.singletonList((IGridJobDescription)element);
        } else if (element instanceof IGridContainer) {
            IGridContainer container = (IGridContainer)element;
            descriptions = this.getDescriptionsFromContainer(container);
        }
        if (descriptions == null && element instanceof IAdaptable && (jsdl = (IGridJobDescription)((IAdaptable)element).getAdapter(IGridJobDescription.class)) != null) {
            descriptions = Collections.singletonList(jsdl);
        }
        return descriptions;
    }

    private List<IGridJobDescription> getDescriptionsFromContainer(IGridContainer container) {
        ArrayList<IGridJobDescription> descriptions = null;
        if (container.isLocal()) {
            try {
                IGridElement[] iGridElementArray = container.getChildren(null);
                int n = iGridElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IGridElement gridElement = iGridElementArray[n2];
                    if (gridElement instanceof IGridJobDescription) {
                        if (descriptions == null) {
                            descriptions = new ArrayList<IGridJobDescription>();
                        }
                        descriptions.add((IGridJobDescription)gridElement);
                    }
                    ++n2;
                }
            }
            catch (ProblemException exception) {
                Activator.logException(exception);
            }
        }
        return descriptions;
    }
}

