/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.IGridJobDescription;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.dialogs.FileOverwriteDialog;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchSite;

public class TransformAction
extends Action {
    protected IGridElementCreator creator;
    protected IGridJobDescription[] input;
    private IWorkbenchSite site;

    public TransformAction(String title, IGridElementCreator creator, IGridJobDescription[] input, IWorkbenchSite site) {
        super(title);
        this.creator = creator;
        this.input = input;
        this.site = site;
    }

    public void run() {
        IGridJobDescription[] iGridJobDescriptionArray = this.input;
        int n = this.input.length;
        int n2 = 0;
        while (n2 < n) {
            IGridJobDescription description = iGridJobDescriptionArray[n2];
            boolean runJob = true;
            IFile file = this.getFile(description);
            if (file.exists()) {
                FileOverwriteDialog dialog = new FileOverwriteDialog(this.site.getShell(), file.getName());
                if (dialog.open() == 64) {
                    try {
                        file.delete(true, null);
                    }
                    catch (CoreException e) {
                        Activator.logException(e);
                    }
                } else {
                    runJob = false;
                }
            }
            if (runJob) {
                WorkspaceJob job = new WorkspaceJob("transformer"){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        return TransformAction.this.transform(TransformAction.this.creator, TransformAction.this.input, monitor);
                    }
                };
                job.setUser(true);
                job.schedule();
            }
            ++n2;
        }
    }

    protected IStatus transform(IGridElementCreator creator, IGridJobDescription[] input, IProgressMonitor monitor) {
        Object result = Status.OK_STATUS;
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        IProgressMonitor lMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        lMonitor.beginTask("Transforming job descriptions", input.length);
        try {
            IGridJobDescription[] iGridJobDescriptionArray = input;
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                IGridJobDescription description = iGridJobDescriptionArray[n2];
                lMonitor.subTask(description.getName());
                IStatus status = this.transform(creator, description);
                if (!status.isOK()) {
                    errors.add(status);
                }
                lMonitor.worked(1);
                ++n2;
            }
        }
        finally {
            lMonitor.done();
        }
        if (errors != null && errors.size() > 0) {
            result = errors.size() == 1 ? (IStatus)errors.get(0) : new MultiStatus("eu.geclipse.ui", 0, errors.toArray(new IStatus[errors.size()]), "Transformation problems", null);
        }
        return result;
    }

    private IStatus transform(IGridElementCreator creator, IGridJobDescription input) {
        IStatus result = Status.OK_STATUS;
        creator.setSource((Object)input);
        IGridContainer parent = input.getParent();
        try {
            creator.create(parent);
        }
        catch (ProblemException pExc) {
            result = new Status(4, "eu.geclipse.ui", String.format("Transformation failed for %s", input.getName()), (Throwable)pExc);
        }
        return result;
    }

    private IFile getFile(IGridJobDescription inputDescr) {
        IFile jdlFile;
        IFile returnFile = null;
        IPath jdlName = new Path(inputDescr.getName()).removeFileExtension().addFileExtension("jdl");
        returnFile = jdlFile = ((IContainer)inputDescr.getParent().getResource()).getFile(jdlName);
        return returnFile;
    }
}

