/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.providers.ConfigurableContentProvider;
import eu.geclipse.ui.providers.IConfigurationListener;
import eu.geclipse.ui.views.ElementManagerViewPart;
import java.net.URL;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;

public class ViewModeAction
extends Action
implements IConfigurationListener {
    static final String VIEW_FLAT_IMAGE = "icons/obj16/view_flat.gif";
    static final String VIEW_HIERARCHICAL_IMAGE = "icons/obj16/view_hierarchical.gif";
    private ElementManagerViewPart view;
    private int viewMode;

    protected ViewModeAction(String name, int viewMode, ElementManagerViewPart view) {
        super(name);
        this.view = view;
        this.viewMode = viewMode;
        this.updateActionState();
        URL imgURL = null;
        if (viewMode == 1) {
            imgURL = Activator.getDefault().getBundle().getEntry(VIEW_FLAT_IMAGE);
        } else if (viewMode == 2) {
            imgURL = Activator.getDefault().getBundle().getEntry(VIEW_HIERARCHICAL_IMAGE);
        }
        if (imgURL != null) {
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)imgURL);
            this.setImageDescriptor(descriptor);
        }
    }

    public void configurationChanged(ConfigurableContentProvider source) {
        if (source == this.getContentProvider()) {
            this.updateActionState();
        }
    }

    public void run() {
        ConfigurableContentProvider contentProvider = this.getContentProvider();
        if (contentProvider != null) {
            contentProvider.setMode(this.viewMode);
            this.view.refreshViewer();
        }
        this.updateActionState();
    }

    public ConfigurableContentProvider getContentProvider() {
        StructuredViewer viewer = this.view.getViewer();
        ConfigurableContentProvider result = null;
        IContentProvider contentProvider = viewer.getContentProvider();
        if (contentProvider instanceof ConfigurableContentProvider) {
            result = (ConfigurableContentProvider)contentProvider;
        }
        return result;
    }

    protected int getProviderMode() {
        int result = 0;
        ConfigurableContentProvider contentProvider = this.getContentProvider();
        if (contentProvider != null) {
            result = contentProvider.getMode();
        }
        return result;
    }

    protected void updateActionState() {
        int pMode = this.getProviderMode();
        this.setChecked(pMode == this.viewMode);
    }
}

