/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.ui.internal.actions.Messages;
import eu.geclipse.ui.internal.actions.ViewModeAction;
import eu.geclipse.ui.providers.ConfigurableContentProvider;
import eu.geclipse.ui.views.ElementManagerViewPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;

public class ViewModeActions
extends ActionGroup {
    private ViewModeAction flatAction;
    private ViewModeAction hierarchicalAction;

    public ViewModeActions(ElementManagerViewPart view) {
        this.flatAction = new ViewModeAction(Messages.getString("ViewModeActions.flat_action_name"), 1, view);
        this.hierarchicalAction = new ViewModeAction(Messages.getString("ViewModeActions.hierarchical_action_name"), 2, view);
        this.registerAction(this.flatAction);
        this.registerAction(this.hierarchicalAction);
    }

    public void dispose() {
        this.unregisterAction(this.flatAction);
        this.unregisterAction(this.hierarchicalAction);
    }

    public void fillActionBars(IActionBars actionBars) {
        IMenuManager menuManager = actionBars.getMenuManager();
        menuManager.add((IAction)this.flatAction);
        menuManager.add((IAction)this.hierarchicalAction);
    }

    protected void registerAction(ViewModeAction action) {
        ConfigurableContentProvider contentProvider = this.flatAction.getContentProvider();
        if (contentProvider != null) {
            contentProvider.addConfigurationListener(action);
        }
    }

    protected void unregisterAction(ViewModeAction action) {
        ConfigurableContentProvider contentProvider = this.flatAction.getContentProvider();
        if (contentProvider != null) {
            contentProvider.removeConfigurationListener(action);
        }
    }
}

