/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.visualisation.AbstractVisualisationAction;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;

public class VisualisationActions
extends ActionGroup {
    private final IWorkbenchPartSite site;
    private final ArrayList<AbstractVisualisationAction> actions = new ArrayList();

    public VisualisationActions(IWorkbenchPartSite site) {
        IExtension[] extensions;
        this.site = site;
        ISelectionProvider selectionProvider = site.getSelectionProvider();
        String fileExtension = "";
        AbstractVisualisationAction actionImpl = null;
        String text = null;
        String tooltip = null;
        IExtensionPoint p = Platform.getExtensionRegistry().getExtensionPoint("eu.geclipse.ui.visualisationAction");
        IExtension[] iExtensionArray = extensions = p.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if ("action".equals(element.getName())) {
                    text = element.getAttribute("text");
                    tooltip = element.getAttribute("tooltip");
                    fileExtension = element.getAttribute("fileExtension");
                    String type = element.getAttribute("type");
                    actionImpl = new AbstractVisualisationAction();
                    actionImpl.init(text, tooltip, fileExtension, (IWorkbenchSite)site, type);
                    selectionProvider.addSelectionChangedListener((ISelectionChangedListener)actionImpl);
                    this.actions.add(actionImpl);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void dispose() {
        ISelectionProvider selectionProvider = this.site.getSelectionProvider();
        for (AbstractVisualisationAction action : this.actions) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)action);
        }
    }

    public void fillContextMenu(IMenuManager mgr) {
        MenuManager submenu = null;
        super.fillContextMenu(mgr);
        for (AbstractVisualisationAction action : this.actions) {
            if (!action.isEnabled()) continue;
            try {
                Class<?> cl = ((IStructuredSelection)this.getContext().getSelection()).getFirstElement().getClass();
                Method met = cl.getMethod("getResourceFileExtension", new Class[0]);
                String resourceFileExt = (String)met.invoke(null, null);
                if (resourceFileExt.compareTo(action.getFileExt()) != 0) continue;
                if (submenu == null) {
                    submenu = new MenuManager("Render");
                    mgr.appendToGroup("group.build", (IContributionItem)submenu);
                }
                submenu.add((IAction)action);
            }
            catch (SecurityException e) {
                Activator.logException(e);
            }
            catch (NoSuchMethodException e) {
                Activator.logException(e);
            }
            catch (IllegalArgumentException e) {
                Activator.logException(e);
            }
            catch (IllegalAccessException e) {
                Activator.logException(e);
            }
            catch (InvocationTargetException e) {
                Activator.logException(e);
            }
        }
    }

    public void updateActionBars() {
        super.updateActionBars();
        IStructuredSelection selection = null;
        if (this.getContext() != null && this.getContext().getSelection() instanceof IStructuredSelection) {
            selection = (IStructuredSelection)this.getContext().getSelection();
        }
        for (AbstractVisualisationAction action : this.actions) {
            action.selectionChanged(selection);
        }
    }
}

