/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.preference;

import eu.geclipse.ui.internal.Activator;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class PerspectivePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String KEY_NOT_SWITCH_FROM_GECLIPSE_PERSPECTIVE = "NotSwitchFromGEclipsePerspectives";
    public static final String KEY_REMEMBER_SWITCHING = "RememberSwitchingPerspective";
    public static final String KEY_DEFAULT_PERSPECTIVE = "DefaultPerspective";

    public PerspectivePreferencePage() {
        super(1);
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        this.setPreferenceStore(preferenceStore);
        this.setDescription("These settings control perspectives for running grid projects. A perspective can automatically open when new grid project is created.");
    }

    protected void createFieldEditors() {
        ImageDescriptor userPerspectiveImage = null;
        ImageDescriptor operatorPerspectiveImage = null;
        ImageDescriptor developerPerspectiveImage = null;
        RadioGroupFieldEditor editor = new RadioGroupFieldEditor(KEY_REMEMBER_SWITCHING, "Open a g-Eclipse perspective after creating a Grid Project", 3, (String[][])new String[][]{{"Always", "always"}, {"Never", "never"}, {"Prompt", "prompt"}}, this.getFieldEditorParent(), true);
        this.addField((FieldEditor)editor);
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        String[][] labels = new String[][]{{"Grid User Perspective", "eu.geclipse.ui.userPerspective"}, {"Grid Operator Perspective", "eu.geclipse.ui.operatorPerspective"}, {"Grid Developer Perspective", "eu.geclipse.ui.developerPerspective"}};
        IPerspectiveDescriptor p = reg.findPerspectiveWithId("eu.geclipse.ui.userPerspective");
        if (p != null) {
            labels[0][0] = p.getLabel();
            userPerspectiveImage = p.getImageDescriptor();
        }
        if ((p = reg.findPerspectiveWithId("eu.geclipse.ui.operatorPerspective")) != null) {
            labels[1][0] = p.getLabel();
            operatorPerspectiveImage = p.getImageDescriptor();
        }
        if ((p = reg.findPerspectiveWithId("eu.geclipse.ui.developerPerspective")) != null) {
            labels[2][0] = p.getLabel();
            developerPerspectiveImage = p.getImageDescriptor();
        }
        editor = new RadioGroupFieldEditor(KEY_DEFAULT_PERSPECTIVE, "Choose perspective to open for new Grid Projects", 1, labels, this.getFieldEditorParent(), true);
        this.addField((FieldEditor)editor);
        Control[] children = editor.getRadioBoxControl(this.getFieldEditorParent()).getChildren();
        if (userPerspectiveImage != null && children[0] != null && children[0] instanceof Button) {
            ((Button)children[0]).setImage(userPerspectiveImage.createImage());
        }
        if (operatorPerspectiveImage != null && children[1] != null && children[1] instanceof Button) {
            ((Button)children[1]).setImage(operatorPerspectiveImage.createImage());
        }
        if (developerPerspectiveImage != null && children[2] != null && children[2] instanceof Button) {
            ((Button)children[2]).setImage(developerPerspectiveImage.createImage());
        }
        BooleanFieldEditor bfe = new BooleanFieldEditor(KEY_NOT_SWITCH_FROM_GECLIPSE_PERSPECTIVE, "Do not switch from other g-Eclipse perspectives (User, Operator or Developer)", this.getFieldEditorParent());
        this.addField((FieldEditor)bfe);
    }

    public void init(IWorkbench workbench) {
    }
}

