/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.transfer;

import eu.geclipse.core.model.IGridElement;
import eu.geclipse.ui.views.GridModelViewPart;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class SelectionTransferDragAdapter
implements TransferDragSourceListener {
    private GridModelViewPart view;

    public SelectionTransferDragAdapter(GridModelViewPart view) {
        Assert.isNotNull((Object)((Object)view));
        this.view = view;
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getInstance();
    }

    public void dragFinished(DragSourceEvent event) {
        LocalSelectionTransfer.getInstance().setSelection(null);
        LocalSelectionTransfer.getInstance().setSelectionSetTime(0L);
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = LocalSelectionTransfer.getInstance().getSelection();
    }

    public void dragStart(DragSourceEvent event) {
        ISelection selection = this.view.getViewer().getSelection();
        event.doit = this.isDragable(selection);
        if (event.doit) {
            LocalSelectionTransfer.getInstance().setSelection(selection);
            LocalSelectionTransfer.getInstance().setSelectionSetTime((long)event.time & 0xFFFFFFFFL);
        }
    }

    protected boolean isDragable(ISelection selection) {
        boolean result = true;
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            Iterator iter = sSelection.iterator();
            while (iter.hasNext() && result) {
                Object obj = iter.next();
                if (obj instanceof IGridElement && this.view.isDragSource((IGridElement)obj)) continue;
                result = false;
            }
        }
        return result;
    }
}

