/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.wizards;

import eu.geclipse.core.ExtensionManager;
import eu.geclipse.ui.internal.wizards.ConfigurationDetailsComposite;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ConfiguratorSelectionPage
extends WizardPage {
    protected Tree confTree;
    private ConfigurationDetailsComposite detailsFolder;

    public ConfiguratorSelectionPage() {
        super("confSelectPage", "Configurators", null);
        this.setDescription("Select one of the available configurators");
    }

    public void createControl(Composite parent) {
        SashForm mainComp = new SashForm(parent, 256);
        mainComp.setLayout((Layout)new FillLayout());
        mainComp.setLayoutData((Object)new GridData(1808));
        Group selectionGroup = new Group((Composite)mainComp, 0);
        selectionGroup.setLayout((Layout)new GridLayout(1, false));
        selectionGroup.setText("Available Configuration");
        this.confTree = new Tree((Composite)selectionGroup, 2818);
        GridData gData = new GridData(4, 4, true, true);
        gData.widthHint = 150;
        this.confTree.setLayoutData((Object)gData);
        Group detailsGroup = new Group((Composite)mainComp, 0);
        detailsGroup.setLayout((Layout)new GridLayout(1, false));
        detailsGroup.setText("Configuration Details");
        this.detailsFolder = new ConfigurationDetailsComposite((Composite)detailsGroup, 0);
        this.detailsFolder.setLayoutData(new GridData(4, 4, true, true));
        mainComp.setWeights(new int[]{1, 2});
        this.confTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfiguratorSelectionPage.this.updateDetails();
                ConfiguratorSelectionPage.this.validatePage();
            }
        });
        this.confTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TreeItem[] selection = ConfiguratorSelectionPage.this.confTree.getSelection();
                if (selection != null && selection.length == 1) {
                    selection[0].setExpanded(!selection[0].getExpanded());
                }
            }
        });
        this.initConfigTree(this.confTree);
        this.updateDetails();
        this.validatePage();
        this.setControl((Control)mainComp);
    }

    public IConfigurationElement[] getSelection() {
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        TreeItem[] selection = this.confTree.getSelection();
        if (selection != null) {
            TreeItem[] treeItemArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                IConfigurationElement configurator = (IConfigurationElement)item.getData("configurator");
                if (configurator != null) {
                    result.add(configurator);
                }
                ++n2;
            }
        }
        return result.toArray(new IConfigurationElement[result.size()]);
    }

    protected void updateDetails() {
        IConfigurationElement configurator = null;
        TreeItem[] selection = this.confTree.getSelection();
        if (selection != null && selection.length == 1) {
            configurator = (IConfigurationElement)selection[0].getData("configurator");
        }
        this.detailsFolder.setConfigurator(configurator);
    }

    protected void validatePage() {
        IConfigurationElement[] selection = this.getSelection();
        this.setPageComplete(selection != null && selection.length > 0);
    }

    private void buildPath(Tree tree, IConfigurationElement element) {
        String[] path;
        TreeItem parent = null;
        String pathAtt = element.getAttribute("path");
        String[] stringArray = path = pathAtt == null ? new String[]{} : pathAtt.split("/");
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            TreeItem[] items = parent == null ? tree.getItems() : parent.getItems();
            TreeItem pItem = null;
            TreeItem[] treeItemArray = items;
            int n3 = items.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem item = treeItemArray[n4];
                if (item.getText().equals(part)) {
                    pItem = item;
                    break;
                }
                ++n4;
            }
            if (pItem == null) {
                pItem = parent == null ? new TreeItem(tree, 0) : new TreeItem(parent, 0);
                pItem.setText(part);
            }
            parent = pItem;
            ++n2;
        }
        TreeItem item = null;
        item = parent == null ? new TreeItem(tree, 0) : new TreeItem(parent, 0);
        String name = element.getAttribute("name");
        item.setText(name);
        item.setData("configurator", (Object)element);
    }

    private void initConfigTree(Tree tree) {
        ExtensionManager manager = new ExtensionManager();
        List elements = manager.getConfigurationElements("eu.geclipse.core.configurator", "configuration");
        for (IConfigurationElement element : elements) {
            this.buildPath(tree, element);
        }
    }
}

