/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.wizards;

import eu.geclipse.core.model.IVoLoader;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.wizards.Messages;
import eu.geclipse.ui.internal.wizards.VoChooserPage;
import eu.geclipse.ui.internal.wizards.VoImportLocationChooserPage;
import eu.geclipse.ui.internal.wizards.VoLoaderSelectionPage;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;

public class VoImportWizard
extends Wizard {
    private VoLoaderSelectionPage selectionPage;
    private VoImportLocationChooserPage locationPage;
    private VoChooserPage chooserPage;

    public VoImportWizard() throws ProblemException {
        this.setNeedsProgressMonitor(true);
        this.selectionPage = new VoLoaderSelectionPage();
        if (this.selectionPage.getAvailableLoaders().size() == 0) {
            throw new ProblemException("eu.geclipse.problem.canNotFindVoLoaders", "eu.geclipse.ui");
        }
        URL imgUrl = Activator.getDefault().getBundle().getEntry("icons/wizban/vo_wiz.gif");
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)imgUrl));
    }

    public void addPages() {
        if (this.selectionPage.initVoLoaderList() > 1) {
            this.addPage((IWizardPage)this.selectionPage);
        }
        this.locationPage = new VoImportLocationChooserPage(this.selectionPage);
        this.addPage((IWizardPage)this.locationPage);
        this.chooserPage = new VoChooserPage(this.locationPage);
        this.addPage((IWizardPage)this.chooserPage);
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.chooserPage;
    }

    public String getWindowTitle() {
        return Messages.getString("VoImportWizard.title");
    }

    public boolean performFinish() {
        boolean result = true;
        WizardPage currentPage = (WizardPage)this.getContainer().getCurrentPage();
        currentPage.setErrorMessage(null);
        IVoLoader loader = this.selectionPage.getSelectedLoader();
        URI location = this.locationPage.getSelectedLocation();
        String[] vos = this.chooserPage.getSelectedVos();
        VoImportOperation op = new VoImportOperation(loader, location, vos);
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException itExc) {
            Throwable cause = itExc.getCause();
            ProblemDialog.openProblem(this.getShell(), Messages.getString("VoImportWizard.import_failed"), Messages.getString("VoImportWizard.import_failed"), cause);
            currentPage.setErrorMessage(cause.getLocalizedMessage());
            result = false;
        }
        catch (InterruptedException intExc) {
            currentPage.setErrorMessage(intExc.getLocalizedMessage());
            result = false;
        }
        ProblemException error = op.getError();
        if (error != null) {
            ProblemDialog.openProblem(this.getShell(), Messages.getString("VoImportWizard.error_dialog_title"), Messages.getString("VoImportWizard.error_dialog_text"), error);
        }
        return result;
    }

    private static class VoImportOperation
    implements IRunnableWithProgress {
        private IVoLoader loader;
        private URI location;
        private String[] vos;
        private ProblemException error;

        VoImportOperation(IVoLoader loader, URI location, String[] vos) {
            this.loader = loader;
            this.location = location;
            this.vos = vos;
        }

        public ProblemException getError() {
            return this.error;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(Messages.getString("VoImportWizard.loading_progress"), this.vos.length);
            this.error = null;
            String[] stringArray = this.vos;
            int n = this.vos.length;
            int n2 = 0;
            while (n2 < n) {
                String certID = stringArray[n2];
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                try {
                    this.loader.createVo(this.location, certID, (IProgressMonitor)subMonitor);
                }
                catch (ProblemException pExc) {
                    if (this.error == null) {
                        this.error = pExc;
                    }
                    this.error.getProblem().merge(pExc.getProblem());
                }
                ++n2;
            }
            monitor.done();
        }
    }
}

