/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.wizards;

import eu.geclipse.core.ExtensionManager;
import eu.geclipse.core.model.IVoLoader;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.wizards.Messages;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoLoaderSelectionPage
extends WizardPage {
    protected org.eclipse.swt.widgets.List list;
    private List<IConfigurationElement> loaders;
    private Hashtable<String, IVoLoader> formerlySelectedLoaders = new Hashtable();

    public VoLoaderSelectionPage() {
        super("voLoaderPage", Messages.getString("VoLoaderSelectionPage.title"), null);
        this.setDescription(Messages.getString("VoLoaderSelectionPage.description"));
    }

    public int initVoLoaderList() {
        ExtensionManager manager = new ExtensionManager();
        this.loaders = new ArrayList<IConfigurationElement>();
        this.loaders.addAll(manager.getConfigurationElements("eu.geclipse.core.voLoader", "loader"));
        return this.loaders.size();
    }

    public List<IConfigurationElement> getAvailableLoaders() {
        if (this.loaders == null) {
            this.initVoLoaderList();
        }
        return this.loaders;
    }

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(1, false));
        GridData gData = new GridData(1808);
        mainComp.setLayoutData((Object)gData);
        this.list = new org.eclipse.swt.widgets.List(mainComp, 2052);
        gData = new GridData(1808);
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        this.list.setLayoutData((Object)gData);
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VoLoaderSelectionPage.this.setPageComplete(VoLoaderSelectionPage.this.list.getSelectionCount() > 0);
            }
        });
        this.setControl((Control)mainComp);
        this.populateList();
        this.setPageComplete(false);
    }

    public IVoLoader getSelectedLoader() {
        IVoLoader result = null;
        String[] selection = null;
        if (this.loaders.size() > 0) {
            selection = new String[]{this.loaders.get(0).getAttribute("name")};
        }
        if (this.list != null) {
            selection = this.list.getSelection();
        }
        if (selection != null && selection.length > 0 && (result = this.formerlySelectedLoaders.get(selection[0])) == null) {
            for (IConfigurationElement element : this.loaders) {
                String name = element.getAttribute("name");
                if (!selection[0].equals(name)) continue;
                try {
                    result = (IVoLoader)element.createExecutableExtension("class");
                    this.formerlySelectedLoaders.put(selection[0], result);
                }
                catch (CoreException cExc) {
                    Activator.logException(cExc);
                }
                break;
            }
        }
        return result;
    }

    protected void populateList() {
        this.list.removeAll();
        if (this.loaders == null) {
            this.initVoLoaderList();
        }
        for (IConfigurationElement element : this.loaders) {
            String name = element.getAttribute("name");
            this.list.add(name);
        }
    }
}

