/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.problems;

import eu.geclipse.core.reporting.ISolver;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.core.util.TimeChecker;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.problems.Messages;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CheckSystemTimeSolution
implements ISolver {
    public void solve() {
        String message;
        Shell shell;
        boolean timeCheckValid;
        boolean timeOK;
        TimeChecker tr;
        block9: {
            tr = new TimeChecker();
            timeOK = false;
            timeCheckValid = true;
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            shell = null;
            if (window != null) {
                shell = window.getShell();
            }
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        tr.checkSysTime(monitor);
                    }
                    catch (ProblemException pe) {
                        throw new InvocationTargetException(pe);
                    }
                }
            };
            try {
                new ProgressMonitorDialog(shell).run(true, true, runnable);
            }
            catch (InterruptedException interruptedException) {
                timeCheckValid = false;
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (!(cause instanceof ProblemException)) break block9;
                String title = Messages.getString("CheckSystemTimeSolution.failed_dialog_title");
                String msg = Messages.getString("CheckSystemTimeSolution.failed_check_system_time");
                ProblemDialog.openProblem(shell, title, msg, cause);
                timeCheckValid = false;
            }
        }
        if (!timeCheckValid) {
            return;
        }
        timeOK = tr.getTimeCheckStatus();
        String title = Messages.getString("CheckSystemTimeSolution.dialog_title");
        Shell parent = shell;
        if (timeOK) {
            message = Messages.getString("CheckSystemTimeSolution.system_clock_ok");
            message = String.format(message, tr.getTolerance());
        } else {
            message = Messages.getString("CheckSystemTimeSolution.system_clock_not_ok");
            message = String.format(message, tr.getOffset());
        }
        message = String.valueOf(message) + ":\n\t" + tr.getSystemDate() + "\n\n";
        message = String.valueOf(message) + Messages.getString("CheckSystemTimeSolution.queried_servers_report");
        message = String.valueOf(message) + ":\n\t" + tr.getReferenceDate();
        if (timeOK) {
            MessageDialog.openInformation((Shell)parent, (String)title, (String)message);
        } else {
            MessageDialog.openError((Shell)parent, (String)title, (String)message);
        }
    }
}

