/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.properties;

import eu.geclipse.core.model.IGridComputing;
import eu.geclipse.info.glue.GlueLocation;
import eu.geclipse.info.model.GridApplication;
import eu.geclipse.ui.properties.AbstractProperty;
import eu.geclipse.ui.properties.AbstractPropertySource;
import eu.geclipse.ui.properties.IProperty;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridApplicationSource
extends AbstractPropertySource<GridApplication> {
    private static List<IProperty<GridApplication>> staticDescriptors;

    public GridApplicationSource(GridApplication sourceObject) {
        super(sourceObject);
    }

    @Override
    protected Class<? extends AbstractPropertySource<?>> getPropertySourceClass() {
        return GridApplicationSource.class;
    }

    @Override
    protected List<IProperty<GridApplication>> getStaticProperties() {
        if (staticDescriptors == null) {
            staticDescriptors = GridApplicationSource.createProperties();
        }
        return staticDescriptors;
    }

    private static List<IProperty<GridApplication>> createProperties() {
        ArrayList<IProperty<GridApplication>> propertiesList = new ArrayList<IProperty<GridApplication>>(1);
        propertiesList.add(GridApplicationSource.createName());
        propertiesList.add(GridApplicationSource.createLocationPath());
        propertiesList.add(GridApplicationSource.createComputing());
        propertiesList.add(GridApplicationSource.createLocationVersion());
        return propertiesList;
    }

    private static IProperty<GridApplication> createName() {
        return new AbstractProperty<GridApplication>("Name", null){

            @Override
            public Object getValue(GridApplication gridApplication) {
                return gridApplication.getName();
            }
        };
    }

    private static IProperty<GridApplication> createLocationPath() {
        return new AbstractProperty<GridApplication>("Location", null){

            @Override
            public Object getValue(GridApplication gridApplication) {
                return gridApplication.getTag();
            }
        };
    }

    private static IProperty<GridApplication> createComputing() {
        return new AbstractProperty<GridApplication>("Computing Elements", null){

            @Override
            public Object getValue(GridApplication gridApplication) {
                IGridComputing[] myComputingArray = gridApplication.getComputing();
                String result = "";
                int i = 0;
                while (myComputingArray != null && i < myComputingArray.length) {
                    result = String.valueOf(result) + myComputingArray[i].getURI() + ";";
                    ++i;
                }
                return result;
            }
        };
    }

    private static IProperty<GridApplication> createLocationVersion() {
        return new AbstractProperty<GridApplication>("Version", null){

            @Override
            public Object getValue(GridApplication gridApplication) {
                String result = "";
                GlueLocation myLocationObject = (GlueLocation)gridApplication.getGlueElement();
                if (myLocationObject != null) {
                    result = myLocationObject.version;
                }
                return result;
            }
        };
    }
}

