/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.properties;

import eu.geclipse.core.filesystem.GEclipseURI;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridConnection;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridRoot;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.properties.Messages;
import eu.geclipse.ui.widgets.GridConnectionDefinitionComposite;
import java.net.URI;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.PropertyPage;

public class GridConnectionPropertiesPage
extends PropertyPage {
    private GridConnectionDefinitionComposite connectionDefinitionComp;

    public boolean performOk() {
        boolean result = false;
        IFolder folder = (IFolder)this.getElement().getAdapter(IFolder.class);
        if (folder != null) {
            URI slaveURI = this.connectionDefinitionComp.getURI();
            GEclipseURI geclURI = new GEclipseURI(slaveURI);
            try {
                folder.delete(true, null);
                folder.createLink(geclURI.toMasterURI(), 16, null);
                result = true;
            }
            catch (CoreException cExc) {
                ProblemDialog.openProblem(this.getShell(), Messages.getString("GridConnectionPropertiesPage.create_link_error_title"), Messages.getString("GridConnectionPropertiesPage.create_link_error_text"), cExc);
            }
        }
        return result;
    }

    public void setElement(IAdaptable element) {
        super.setElement(element);
        this.updateConnectionDefinitionComposite();
    }

    protected Control createContents(Composite parent) {
        this.connectionDefinitionComp = new GridConnectionDefinitionComposite(null, parent, 0);
        this.updateConnectionDefinitionComposite();
        return this.connectionDefinitionComp;
    }

    protected void performDefaults() {
        this.updateConnectionDefinitionComposite();
        super.performDefaults();
    }

    private void updateConnectionDefinitionComposite() {
        if (this.connectionDefinitionComp != null) {
            IFolder folder = (IFolder)this.getElement().getAdapter(IFolder.class);
            if (folder != null) {
                IGridRoot root = GridModel.getRoot();
                IGridElement element = root.findElement((IResource)folder);
                if (element != null && element instanceof IGridConnection) {
                    URI uri = ((IGridConnection)element).getURI();
                    this.connectionDefinitionComp.setURI(uri);
                    this.connectionDefinitionComp.setEnabled(true);
                } else {
                    this.connectionDefinitionComp.setEnabled(false);
                }
            } else {
                this.connectionDefinitionComp.setEnabled(false);
            }
        }
    }
}

