/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.properties;

import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.properties.Messages;
import eu.geclipse.ui.widgets.GridProjectStructureComposite;
import java.util.Hashtable;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.PropertyPage;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class GridProjectFoldersPropertiesPage
extends PropertyPage {
    private GridProjectStructureComposite projectStructureComposite;

    public boolean performOk() {
        boolean result = true;
        IProject project = (IProject)this.getElement().getAdapter(IProject.class);
        if (project != null) {
            try {
                ProjectScope projectScope = new ProjectScope(project);
                IEclipsePreferences folderNode = projectScope.getNode("eu.geclipse.core.folders");
                Hashtable<String, String> folders = this.projectStructureComposite.getProjectFolders();
                boolean updateNeeded = false;
                String[] stringArray = folderNode.keys();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource;
                    String id = stringArray[n2];
                    String oldLabel = folderNode.get(id, null);
                    String newLabel = folders.get(id);
                    if (newLabel == null) {
                        folderNode.remove(id);
                        updateNeeded = true;
                    } else if (!newLabel.equals(oldLabel) && (resource = project.findMember(oldLabel)) != null) {
                        IPath path = resource.getFullPath();
                        path = path.removeLastSegments(1);
                        path = path.append(newLabel);
                        try {
                            resource.move(path, true, null);
                            folderNode.put(id, newLabel);
                            updateNeeded = true;
                        }
                        catch (CoreException cExc) {
                            Activator.logException(cExc);
                        }
                    }
                    ++n2;
                }
                for (String id : folders.keySet()) {
                    String oldLabel = folderNode.get(id, null);
                    if (oldLabel != null) continue;
                    String label = folders.get(id);
                    IFolder folder = project.getFolder((IPath)new Path(label));
                    if (!folder.exists()) {
                        try {
                            folder.create(1, true, null);
                        }
                        catch (CoreException cExc) {
                            Activator.logException(cExc);
                        }
                    }
                    folderNode.put(id, label);
                    updateNeeded = true;
                }
                if (updateNeeded) {
                    WorkspaceJob updater = new WorkspaceJob("project_folder_updater", (Preferences)folderNode){
                        private final /* synthetic */ Preferences val$folderNode;
                        {
                            this.val$folderNode = preferences;
                            super($anonymous0);
                        }

                        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                            IStatus jobResult = Status.OK_STATUS;
                            try {
                                this.val$folderNode.flush();
                            }
                            catch (BackingStoreException bsExc) {
                                jobResult = new Status(4, "eu.geclipse.ui", Messages.getString("GridProjectFoldersPropertiesPage.project_setup_error"), (Throwable)bsExc);
                            }
                            return jobResult;
                        }
                    };
                    updater.setRule((ISchedulingRule)project);
                    updater.setSystem(true);
                    updater.schedule();
                }
            }
            catch (BackingStoreException bsExc) {
                Activator.logException(bsExc);
                result = false;
            }
        }
        return result;
    }

    public void setElement(IAdaptable element) {
        super.setElement(element);
        this.updateProjectStructureComposite();
    }

    protected Control createContents(Composite parent) {
        this.projectStructureComposite = new GridProjectStructureComposite(parent, 0);
        this.updateProjectStructureComposite();
        return this.projectStructureComposite;
    }

    protected void performDefaults() {
        this.projectStructureComposite.performDefaults();
        super.performDefaults();
    }

    private void updateProjectStructureComposite() {
        if (this.projectStructureComposite != null) {
            IProject project = (IProject)this.getElement().getAdapter(IProject.class);
            if (project != null) {
                try {
                    this.projectStructureComposite.setProject(project);
                    this.projectStructureComposite.setEnabled(true);
                }
                catch (CoreException cExc) {
                    Activator.logException(cExc);
                }
            } else {
                this.projectStructureComposite.setEnabled(false);
            }
        }
    }
}

