/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.properties;

import eu.geclipse.ui.properties.AbstractPropertySource;
import eu.geclipse.ui.properties.IPropertiesFactory;
import eu.geclipse.ui.properties.PropertyId;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertySourceProxy
implements IPropertySource {
    private final List<AbstractPropertySource<?>> propertySourcesList = new ArrayList();
    private final Object sourceObject;

    PropertySourceProxy(List<IPropertiesFactory> factoriesList, Object sourceObject) {
        this.sourceObject = sourceObject;
        for (IPropertiesFactory factory : factoriesList) {
            List<AbstractPropertySource<?>> sourcesList = factory.getPropertySources(sourceObject);
            if (sourcesList == null || sourcesList.isEmpty()) continue;
            this.propertySourcesList.addAll(sourcesList);
        }
    }

    public Object getEditableValue() {
        return this.sourceObject;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<IPropertyDescriptor> descriptors = new ArrayList<IPropertyDescriptor>();
        for (AbstractPropertySource<?> propertySource : this.propertySourcesList) {
            descriptors.addAll(propertySource.getPropertyDescriptors());
        }
        return descriptors.toArray(new IPropertyDescriptor[descriptors.size()]);
    }

    public Object getPropertyValue(Object finalId) {
        PropertyId propertyId;
        AbstractPropertySource<?> propertySource;
        Object value = null;
        if (finalId instanceof PropertyId && (propertySource = this.findPropertySource((propertyId = (PropertyId)finalId).getSourceClass())) != null) {
            value = propertySource.getPropertyValue(propertyId.getProperty());
        }
        return value;
    }

    public boolean isPropertySet(Object finalId) {
        return false;
    }

    public void resetPropertyValue(Object finalId) {
    }

    public void setPropertyValue(Object finalId, Object finalValue) {
    }

    private AbstractPropertySource<?> findPropertySource(Class<? extends AbstractPropertySource<?>> propertySourceClass) {
        AbstractPropertySource<?> propertySource = null;
        Iterator<AbstractPropertySource<?>> iterator = this.propertySourcesList.iterator();
        while (iterator.hasNext() && propertySource == null) {
            AbstractPropertySource<?> currentPropSource = iterator.next();
            propertySource = currentPropSource.getPropertySourceInstanceFor(propertySourceClass);
        }
        return propertySource;
    }
}

