/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.providers;

import eu.geclipse.core.model.IGridApplication;
import eu.geclipse.core.model.IGridComputing;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.core.model.IGridJobDescription;
import eu.geclipse.core.model.IGridService;
import eu.geclipse.core.model.IGridStorage;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.IWrappedElement;
import eu.geclipse.core.model.impl.ContainerMarker;
import eu.geclipse.info.model.GridGlueService;
import eu.geclipse.ui.internal.Activator;
import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class GridModelLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    public static final String INFO_MARKER = "icons/obj16/info_obj.gif";
    public static final String ERROR_MARKER = "icons/obj16/ihigh_obj.gif";
    private static final String APPLICATION_ELEMENT = "icons/obj16/application_obj.gif";
    private static Hashtable<String, Image> images = new Hashtable();
    private Image computingImage;
    private Image jobImage;
    private Image jobDescriptionImage;
    private Image serviceImage;
    private Image serviceUnsupportedImage;
    private Image storageImage;
    private Image voImage;
    private Image virtualContainerImage;
    private Image virtualElementImage;
    private ILabelProvider workbenchLabelProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();

    public Image getImage(Object element) {
        Image result = null;
        result = element instanceof IGridElement ? this.getImage((IGridElement)element) : super.getImage(element);
        return result;
    }

    public String getText(Object element) {
        String resultText = null;
        resultText = element instanceof IGridJob ? ((IGridJob)element).getJobName() : (element instanceof IGridElement ? ((IGridElement)element).getName() : element.toString());
        return resultText;
    }

    private Image getImage(IGridElement element) {
        Image result = null;
        result = element.isVirtual() ? this.getVirtualElementImage(element) : this.getRealElementImage(element);
        return result;
    }

    private Image getRealElementImage(IGridElement element) {
        Image result = null;
        if (element instanceof IGridJob) {
            result = this.getJobImage();
        } else if (element instanceof IGridJobDescription) {
            result = this.getJobDescriptionImage();
        } else {
            IResource resource = element.getResource();
            result = this.workbenchLabelProvider.getImage((Object)resource);
        }
        return result;
    }

    private Image getVirtualElementImage(IGridElement element) {
        boolean isSupported;
        IGridElement wrappedElement;
        Image result = null;
        result = element instanceof IVirtualOrganization ? this.getVoImage() : (element instanceof IGridApplication ? GridModelLabelProvider.getImage(APPLICATION_ELEMENT) : (element instanceof IGridComputing ? this.getComputingImage() : (element instanceof IGridStorage ? this.getStorageImage() : (element instanceof IGridService ? (element instanceof IWrappedElement ? ((wrappedElement = ((IWrappedElement)element).getWrappedElement()) instanceof GridGlueService ? ((isSupported = ((GridGlueService)wrappedElement).getGlueService().isSupported()) ? this.getServiceImage() : this.getUnsupportedServiceImage()) : this.getServiceImage()) : this.getServiceImage()) : (element instanceof IGridContainer ? this.getVirtualContainerImage() : (element instanceof ContainerMarker ? this.getContainerMarkerImage((ContainerMarker)element) : this.getVirtualElementImage()))))));
        return result;
    }

    private Image getContainerMarkerImage(ContainerMarker marker) {
        Image result = null;
        ContainerMarker.MarkerType type = marker.getType();
        if (type == ContainerMarker.MarkerType.INFO) {
            result = GridModelLabelProvider.getImage(INFO_MARKER);
        } else if (type == ContainerMarker.MarkerType.ERROR) {
            result = GridModelLabelProvider.getImage(ERROR_MARKER);
        }
        return result;
    }

    private Image getJobImage() {
        if (this.jobImage == null) {
            this.jobImage = Activator.getDefault().getImageRegistry().get("job");
        }
        return this.jobImage;
    }

    private Image getJobDescriptionImage() {
        if (this.jobDescriptionImage == null) {
            this.jobDescriptionImage = Activator.getDefault().getImageRegistry().get("jobdescription");
        }
        return this.jobDescriptionImage;
    }

    private Image getVirtualContainerImage() {
        if (this.virtualContainerImage == null) {
            this.virtualContainerImage = Activator.getDefault().getImageRegistry().get("virtualfolder");
        }
        return this.virtualContainerImage;
    }

    private Image getVirtualElementImage() {
        if (this.virtualElementImage == null) {
            this.virtualElementImage = Activator.getDefault().getImageRegistry().get("virtualfile");
        }
        return this.virtualElementImage;
    }

    private Image getVoImage() {
        if (this.voImage == null) {
            this.voImage = Activator.getDefault().getImageRegistry().get("vo");
        }
        return this.voImage;
    }

    private Image getServiceImage() {
        if (this.serviceImage == null) {
            this.serviceImage = Activator.getDefault().getImageRegistry().get("service");
        }
        return this.serviceImage;
    }

    private Image getUnsupportedServiceImage() {
        if (this.serviceUnsupportedImage == null) {
            this.serviceUnsupportedImage = Activator.getDefault().getImageRegistry().get("service_unsupported");
        }
        return this.serviceUnsupportedImage;
    }

    private Image getStorageImage() {
        if (this.storageImage == null) {
            this.storageImage = Activator.getDefault().getImageRegistry().get("storage");
        }
        return this.storageImage;
    }

    private Image getComputingImage() {
        if (this.computingImage == null) {
            this.computingImage = Activator.getDefault().getImageRegistry().get("computing");
        }
        return this.computingImage;
    }

    private static Image getImage(String path) {
        Image image = images.get(path);
        if (image == null) {
            image = GridModelLabelProvider.loadImage(path);
            images.put(path, image);
        }
        return image;
    }

    private static Image loadImage(String path) {
        URL url = Activator.getDefault().getBundle().getEntry(path);
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
        return descriptor.createImage();
    }

    public StyledString getStyledText(Object element) {
        String text = this.getText(element);
        if (text == null) {
            text = "";
        }
        return new StyledString(text);
    }
}

