/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.simpleTest;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortScanJob
extends Job {
    protected TreeMap<Integer, Boolean> portMap;
    protected Display display;
    protected Display display2;
    protected TreeItem treeItem;
    InetAddress ia;
    StyledText results;
    int portsScanned;
    int portsOpen;
    int portsClosed;
    int serverPort;

    public PortScanJob(InetAddress address, TreeMap<Integer, Boolean> map, StyledText results, TreeItem treeItem) {
        super("Port Scan Job");
        this.ia = address;
        this.portMap = map;
        this.results = results;
        this.treeItem = treeItem;
        this.display = this.treeItem.getDisplay();
        this.display2 = this.results.getDisplay();
    }

    protected IStatus run(IProgressMonitor monitor) {
        int p = 0;
        Integer[] ports = new Integer[this.portMap.keySet().size()];
        this.portMap.keySet().toArray(ports);
        IStatus result = Status.CANCEL_STATUS;
        monitor.beginTask("Port Scan", ports.length);
        Socket s = null;
        long timeBefore = System.currentTimeMillis();
        p = 0;
        while (p < ports.length && !monitor.isCanceled()) {
            try {
                this.serverPort = ports[p];
                s = new Socket();
                s.connect(new InetSocketAddress(this.ia, this.serverPort), 100);
                s.close();
                this.portMap.put(ports[p], true);
                ++this.portsOpen;
                if (!this.display.isDisposed()) {
                    this.display.syncExec(new Runnable(){

                        public void run() {
                            if (!PortScanJob.this.treeItem.isDisposed()) {
                                PortScanJob.this.treeItem.setText(new String[]{PortScanJob.this.ia.getHostName(), "OK"});
                                TreeItem portItem = new TreeItem(PortScanJob.this.treeItem, 0);
                                portItem.setText(new String[]{"" + PortScanJob.this.serverPort, "Open"});
                            }
                        }
                    });
                }
            }
            catch (IOException iOException) {
                ++this.portsClosed;
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (IOException iOException2) {}
            }
            monitor.worked(1);
            ++p;
        }
        long timeAfter = System.currentTimeMillis();
        final long resultTime = timeAfter - timeBefore;
        this.portsScanned = p;
        if (!this.display2.isDisposed()) {
            this.display2.syncExec(new Runnable(){

                public void run() {
                    if (!PortScanJob.this.results.isDisposed()) {
                        PortScanJob.this.results.append("Statistics for " + PortScanJob.this.ia + "\n" + "Ports scanned:\t\t" + PortScanJob.this.portsScanned + "\n" + "Ports openned:\t" + PortScanJob.this.portsOpen + "\n" + "Ports closed:\t\t" + PortScanJob.this.portsClosed + "\n" + "Total Processing time: " + resultTime + " ms\n\n");
                    }
                }
            });
        }
        this.portMap.clear();
        this.portsScanned = 0;
        this.portsOpen = 0;
        this.portsClosed = 0;
        monitor.done();
        result = Status.OK_STATUS;
        return result;
    }
}

