/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridModelEvent;
import eu.geclipse.core.model.IGridModelListener;
import eu.geclipse.ui.decorators.GridProjectFolderDecorator;
import eu.geclipse.ui.internal.actions.AccessControlActions;
import eu.geclipse.ui.internal.actions.ActionGroupManager;
import eu.geclipse.ui.internal.actions.CommonActions;
import eu.geclipse.ui.internal.actions.FileActions;
import eu.geclipse.ui.internal.actions.MountActions;
import eu.geclipse.ui.internal.actions.OpenActions;
import eu.geclipse.ui.internal.actions.TreeViewerActions;
import eu.geclipse.ui.internal.transfer.SelectionTransferDragAdapter;
import eu.geclipse.ui.internal.transfer.SelectionTransferDropAdapter;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.DelegatingDragAdapter;
import org.eclipse.jface.util.DelegatingDropAdapter;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.ViewPart;

public abstract class GridModelViewPart
extends ViewPart
implements IGridModelListener {
    StructuredViewer viewer;
    private ActionGroup actions;
    private OpenActions openActions;

    public void createPartControl(Composite parent) {
        this.viewer = this.createViewer(parent);
        this.initViewer(this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.actions = this.createActions();
        this.fillActionBars(this.actions);
        this.createContextMenu(this.viewer);
        GridModel.getRoot().addGridModelListener((IGridModelListener)this);
        this.updateActionBars();
    }

    private void updateActionBars() {
        if (this.actions != null) {
            ISelection selection = this.viewer.getSelection();
            this.actions.setContext(new ActionContext(selection));
            this.actions.updateActionBars();
        }
    }

    public void dispose() {
        if (this.actions != null) {
            this.actions.dispose();
        }
        GridModel.getRoot().removeGridModelListener((IGridModelListener)this);
        super.dispose();
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    public void gridModelChanged(IGridModelEvent event) {
        GridProjectFolderDecorator decorator;
        if (event.getType() == 1 || event.getType() == 2) {
            this.refreshViewer(event.getSource());
        } else if (event.getType() == 6 && (decorator = GridProjectFolderDecorator.getDecorator()) != null) {
            decorator.refresh(event.getElements());
        }
    }

    public boolean isDragSource(IGridElement element) {
        return !element.isVirtual();
    }

    public void refreshViewer() {
        this.refreshViewer(null);
    }

    public void refreshViewer(final IGridElement element) {
        Control control;
        if (this.viewer != null && !(control = this.viewer.getControl()).isDisposed()) {
            Display display = control.getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    if (!GridModelViewPart.this.viewer.getControl().isDisposed()) {
                        if (element == null) {
                            GridModelViewPart.this.viewer.refresh(false);
                        } else {
                            GridModelViewPart.this.viewer.refresh((Object)element, false);
                        }
                    }
                }
            });
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    protected void addDragSourceListeners(DelegatingDragAdapter adapter) {
        adapter.addDragSourceListener((TransferDragSourceListener)new SelectionTransferDragAdapter(this));
    }

    protected void addDropTargetListeners(DelegatingDropAdapter adapter) {
        adapter.addDropTargetListener((TransferDropTargetListener)new SelectionTransferDropAdapter());
    }

    protected ActionGroup createActions() {
        ActionGroupManager manager = new ActionGroupManager();
        this.contributeAdditionalActions(manager);
        this.contributeStandardActions(manager);
        return manager;
    }

    protected void contributeStandardActions(ActionGroupManager groups) {
        this.openActions = new OpenActions(this);
        groups.addGroup(this.openActions);
        FileActions fileActions = new FileActions(this);
        groups.addGroup(fileActions);
        MountActions mountActions = new MountActions(this.getSite());
        groups.addGroup(mountActions);
        AccessControlActions aclActions = new AccessControlActions(this.getSite());
        groups.addGroup(aclActions);
        CommonActions commonActions = new CommonActions(this);
        groups.addGroup(commonActions);
        StructuredViewer sViewer = this.getViewer();
        if (sViewer instanceof TreeViewer) {
            TreeViewer tViewer = (TreeViewer)sViewer;
            TreeViewerActions treeViewerActions = new TreeViewerActions(tViewer);
            groups.addGroup(treeViewerActions);
        }
    }

    protected void contributeAdditionalActions(ActionGroupManager groups) {
    }

    protected abstract IContentProvider createContentProvider();

    protected void createContextMenu(StructuredViewer sViewer) {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                GridModelViewPart.this.fillContextMenu(mgr);
            }
        });
        Menu menu = manager.createContextMenu(sViewer.getControl());
        sViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)sViewer);
    }

    protected void createContextMenuGroups(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new GroupMarker("group.goto"));
        menu.add((IContributionItem)new GroupMarker("group.open"));
        menu.add((IContributionItem)new GroupMarker("group.openWith"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new GroupMarker("group.show"));
        menu.add((IContributionItem)new GroupMarker("group.reorganize"));
        menu.add((IContributionItem)new GroupMarker("group.port"));
        menu.add((IContributionItem)new Separator("group.generate"));
        menu.add((IContributionItem)new Separator("group.search"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.properties"));
    }

    protected abstract IBaseLabelProvider createLabelProvider();

    protected abstract StructuredViewer createViewer(Composite var1);

    protected void fillActionBars(ActionGroup group) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        group.fillActionBars(actionBars);
    }

    protected void fillContextMenu(IMenuManager menu) {
        ISelection selection = this.viewer.getSelection();
        ActionContext context = new ActionContext(selection);
        this.createContextMenuGroups(menu);
        this.actions.setContext(context);
        this.actions.fillContextMenu(menu);
        this.actions.setContext(null);
    }

    protected abstract IGridElement getRootElement();

    protected void handleDoubleClick(DoubleClickEvent event) {
        if (this.viewer instanceof TreeViewer) {
            Object element;
            TreeViewer treeViewer = (TreeViewer)this.viewer;
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection && treeViewer.isExpandable(element = ((IStructuredSelection)selection).getFirstElement())) {
                boolean state = treeViewer.getExpandedState(element);
                treeViewer.setExpandedState(element, !state);
            }
        }
    }

    protected void handleOpen(OpenEvent event) {
        this.openActions.delegateOpenEvent(event);
    }

    protected void initDragAndDrop(StructuredViewer sViewer) {
        this.initDrag(sViewer);
        this.initDrop(sViewer);
    }

    protected void initDrag(StructuredViewer sViewer) {
        int operations = 19;
        DelegatingDragAdapter adapter = new DelegatingDragAdapter();
        this.addDragSourceListeners(adapter);
        sViewer.addDragSupport(operations, adapter.getTransfers(), (DragSourceListener)adapter);
    }

    protected void initDrop(StructuredViewer sViewer) {
        int operations = 19;
        DelegatingDropAdapter adapter = new DelegatingDropAdapter();
        this.addDropTargetListeners(adapter);
        sViewer.addDropSupport(operations, adapter.getTransfers(), (DropTargetListener)adapter);
    }

    protected void initViewer(StructuredViewer sViewer) {
        sViewer.setLabelProvider(this.createLabelProvider());
        sViewer.setContentProvider(this.createContentProvider());
        sViewer.setInput((Object)this.getRootElement());
        this.registerViewerListeners(sViewer);
        this.initDragAndDrop(sViewer);
    }

    protected void registerViewerListeners(StructuredViewer sViewer) {
        sViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                GridModelViewPart.this.handleDoubleClick(event);
            }
        });
        sViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                GridModelViewPart.this.handleOpen(event);
            }
        });
    }
}

