/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views.filters;

import eu.geclipse.ui.dialogs.ConfigureFiltersDialog;
import eu.geclipse.ui.views.filters.IFilterConfigurationListener;
import eu.geclipse.ui.views.filters.IGridFilter;
import eu.geclipse.ui.views.filters.IGridFilterConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GridFilterConfigurationsManager {
    public static final String ID_JOBVIEW = "JobView";
    private static final String MEMENTO_TYPE_CONFIGURATIONS_LIST = "FilterConfigurationsList";
    private static final String MEMENTO_TYPE_CONFIGURATION = "FilterConfiguration";
    private String id;
    private List<IGridFilterConfiguration> configurations = new ArrayList<IGridFilterConfiguration>();
    private List<IFilterConfigurationListener> listeners = new ArrayList<IFilterConfigurationListener>();

    public GridFilterConfigurationsManager(String id) {
        this.id = id;
    }

    public abstract IGridFilterConfiguration createConfiguration(String var1);

    public void saveState(IMemento memento) {
        if (memento != null && !this.configurations.isEmpty()) {
            IMemento configurationsListMemento = memento.createChild(this.getMementoTypeName());
            for (IGridFilterConfiguration configuration : this.configurations) {
                IMemento configurationMemento = configurationsListMemento.createChild(MEMENTO_TYPE_CONFIGURATION, configuration.getName());
                configuration.saveState(configurationMemento);
            }
        }
    }

    public void readState(IMemento memento) {
        IMemento configurationsListMemento;
        this.configurations.clear();
        if (memento != null && (configurationsListMemento = memento.getChild(this.getMementoTypeName())) != null) {
            IMemento[] iMementoArray = configurationsListMemento.getChildren(MEMENTO_TYPE_CONFIGURATION);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento configurationMemento = iMementoArray[n2];
                String nameString = configurationMemento.getID();
                if (nameString != null) {
                    IGridFilterConfiguration configuration = this.createConfiguration(nameString);
                    configuration.read(configurationMemento);
                    this.configurations.add(configuration);
                }
                ++n2;
            }
        }
        this.fireConfigurationChanged();
        this.fireFilterConfigurationSelected();
    }

    public ViewerFilter[] getEnabledFilters() {
        ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>();
        for (IGridFilterConfiguration configuration : this.configurations) {
            if (!configuration.isEnabled()) continue;
            for (IGridFilter filter : configuration.getFilters()) {
                if (!filter.isEnabled()) continue;
                filters.add(filter.getFilter());
            }
        }
        return filters.toArray(new ViewerFilter[filters.size()]);
    }

    private String getMementoTypeName() {
        return "FilterConfigurationsList." + this.id;
    }

    public final List<IGridFilterConfiguration> getConfigurations() {
        return this.configurations;
    }

    public boolean configure(Shell shell) {
        boolean configurationChanged = false;
        ConfigureFiltersDialog dialog = new ConfigureFiltersDialog(shell, this);
        if (dialog.open() == 0) {
            this.configurations = dialog.getConfigurations();
            configurationChanged = true;
            this.fireConfigurationChanged();
            this.fireFilterConfigurationSelected();
        }
        return configurationChanged;
    }

    public void enableConfiguration(IGridFilterConfiguration configuration) {
        for (IGridFilterConfiguration curConfiguration : this.configurations) {
            curConfiguration.setEnabled(curConfiguration == configuration);
        }
        this.fireFilterConfigurationSelected();
    }

    public void addConfigurationListener(IFilterConfigurationListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeConfigurationListener(IFilterConfigurationListener listener) {
        this.listeners.remove(listener);
    }

    private void fireConfigurationChanged() {
        for (IFilterConfigurationListener listener : this.listeners) {
            listener.configurationChanged();
        }
    }

    private void fireFilterConfigurationSelected() {
        ViewerFilter[] filters = this.getEnabledFilters();
        for (IFilterConfigurationListener listener : this.listeners) {
            listener.filterConfigurationSelected(filters);
        }
    }
}

