/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views.jobdetails;

import eu.geclipse.core.model.IGridJob;
import eu.geclipse.ui.views.jobdetails.IJobDetail;
import eu.geclipse.ui.views.jobdetails.IJobDetailsSection;
import eu.geclipse.ui.views.jobdetails.IViewConfiguration;
import eu.geclipse.ui.views.jobdetails.JobDetail;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class JobTextDetail
extends JobDetail {
    private final String name;
    private Label descriptionLabel;
    private Text detailText;

    public JobTextDetail(IJobDetailsSection section, String name) {
        super(section);
        this.name = name;
    }

    protected abstract String getValue(IGridJob var1);

    protected void createWidgets(Composite parent, FormToolkit formToolkit) {
        this.descriptionLabel = formToolkit.createLabel(parent, String.valueOf(this.name) + ":");
        GridData layoutData = new GridData();
        layoutData.verticalAlignment = 128;
        this.descriptionLabel.setLayoutData((Object)layoutData);
        this.detailText = new Text(parent, 10);
        GridData gridData = new GridData();
        gridData.widthHint = 250;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.detailText.setLayoutData((Object)gridData);
    }

    protected boolean isWidgetCreated() {
        return this.descriptionLabel != null && !this.descriptionLabel.isDisposed();
    }

    protected boolean refresh(IGridJob gridJob, IViewConfiguration viewConfiguration) {
        String detail = null;
        if (gridJob != null) {
            detail = this.getValue(gridJob);
        }
        if (detail == null) {
            this.detailText.setText("");
            this.setVisible(viewConfiguration.isShowEmptyEnabled());
        } else {
            this.detailText.setText(detail);
            this.setVisible(true);
        }
        return detail != null;
    }

    public String getId() {
        return this.name;
    }

    public void reuseWidgets(IJobDetail oldDetail) {
        JobTextDetail textDetail = (JobTextDetail)oldDetail;
        this.descriptionLabel = textDetail.descriptionLabel;
        this.detailText = textDetail.detailText;
    }

    public void dispose() {
        this.dispose((Widget)this.descriptionLabel);
        this.dispose((Widget)this.detailText);
        this.descriptionLabel = null;
        this.detailText = null;
    }

    protected void dispose(Widget widget) {
        if (widget != null && !widget.isDisposed()) {
            widget.dispose();
        }
    }

    protected void setVisible(boolean visible) {
        this.setVisible((Control)this.descriptionLabel, visible);
        this.setVisible((Control)this.detailText, visible);
    }

    protected Label getDescriptionLabel() {
        return this.descriptionLabel;
    }

    protected Text getDetailText() {
        return this.detailText;
    }

    protected String getName() {
        return this.name;
    }
}

