/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.widgets;

import eu.geclipse.core.security.X509Util;
import java.math.BigInteger;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateInfoPanel
extends Composite {
    protected Text valueText;
    private X509Certificate[] certificateChain;
    private ScrolledComposite overviewComp;
    private Composite overviewPanel;
    private Table chainTable;
    private Tree detailsTree;
    private Label validText;
    private Label notBeforeText;
    private Label notAfterText;
    private Label sNoText;
    private Hashtable<String, Label> subjectLabels = new Hashtable();
    private Hashtable<String, Label> issuerLabels = new Hashtable();

    public CertificateInfoPanel(Composite parent, int style) {
        super(parent, style);
        FontData[] fontData;
        this.setLayout((Layout)new GridLayout(1, false));
        TabFolder tabFolder = new TabFolder((Composite)this, 0);
        GridData gData = new GridData(4, 4, true, true);
        gData.widthHint = 300;
        gData.heightHint = 400;
        tabFolder.setLayoutData((Object)gData);
        TabItem overviewItem = new TabItem(tabFolder, 0);
        overviewItem.setText("Overview");
        this.overviewComp = new ScrolledComposite((Composite)tabFolder, 512);
        this.overviewComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.overviewComp.setExpandHorizontal(true);
        this.overviewComp.setExpandVertical(true);
        overviewItem.setControl((Control)this.overviewComp);
        this.overviewPanel = new Composite((Composite)this.overviewComp, 0);
        this.overviewPanel.setLayout((Layout)new GridLayout(1, false));
        this.overviewComp.setContent((Control)this.overviewPanel);
        Group generalGroup = new Group(this.overviewPanel, 0);
        generalGroup.setText("General");
        generalGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        generalGroup.setLayout((Layout)new GridLayout(2, false));
        Label validLabel = new Label((Composite)generalGroup, 0);
        validLabel.setText("Valid:");
        this.validText = new Label((Composite)generalGroup, 0);
        Font font = this.validText.getFont();
        FontData[] fontDataArray = fontData = font.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fData = fontDataArray[n2];
            int fStyle = fData.getStyle();
            fData.setStyle(fStyle | 1);
            ++n2;
        }
        this.validText.setFont(new Font(font.getDevice(), fontData));
        Label notBeforeLabel = new Label((Composite)generalGroup, 0);
        notBeforeLabel.setText("Not before:");
        this.notBeforeText = new Label((Composite)generalGroup, 0);
        Label notAfterLabel = new Label((Composite)generalGroup, 0);
        notAfterLabel.setText("Not after:");
        this.notAfterText = new Label((Composite)generalGroup, 0);
        Label sNoLabel = new Label((Composite)generalGroup, 0);
        sNoLabel.setText("Serial Number:");
        this.sNoText = new Label((Composite)generalGroup, 0);
        this.createX500PrincipalGroup(this.overviewPanel, "Issued to", this.subjectLabels);
        this.createX500PrincipalGroup(this.overviewPanel, "Issued from", this.issuerLabels);
        TabItem detailsItem = new TabItem(tabFolder, 0);
        detailsItem.setText("Details");
        SashForm detailsForm = new SashForm((Composite)tabFolder, 512);
        detailsForm.setLayout((Layout)new FillLayout());
        detailsItem.setControl((Control)detailsForm);
        Composite tableComp = new Composite((Composite)detailsForm, 0);
        tableComp.setLayout((Layout)new GridLayout(1, false));
        Label tableLabel = new Label(tableComp, 0);
        tableLabel.setText("Certificate chain");
        this.chainTable = new Table(tableComp, 2820);
        this.chainTable.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite treeComp = new Composite((Composite)detailsForm, 0);
        treeComp.setLayout((Layout)new GridLayout(1, false));
        Label treeLabel = new Label(treeComp, 0);
        treeLabel.setText("Certificate structure");
        this.detailsTree = new Tree(treeComp, 2816);
        this.detailsTree.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite valueComp = new Composite((Composite)detailsForm, 0);
        valueComp.setLayout((Layout)new GridLayout(1, false));
        Label valueLabel = new Label(valueComp, 0);
        valueLabel.setText("Field value");
        this.valueText = new Text(valueComp, 2826);
        this.valueText.setLayoutData((Object)new GridData(4, 4, true, true));
        Display display = Display.getDefault();
        FontData[] fData = display.getSystemFont().getFontData();
        int fHeight = fData != null && fData.length > 0 ? fData[0].getHeight() : 10;
        this.valueText.setFont(new Font((Device)Display.getDefault(), new FontData("Courier", fHeight, 0)));
        detailsForm.setWeights(new int[]{1, 2, 1});
        this.chainTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificateInfoPanel.this.fillDetailsTree();
            }
        });
        this.detailsTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem item = (TreeItem)e.item;
                if (item != null && item.getData() != null && !CertificateInfoPanel.this.valueText.isDisposed()) {
                    CertificateInfoPanel.this.valueText.setText(item.getData().toString());
                } else {
                    CertificateInfoPanel.this.valueText.setText("");
                }
            }
        });
        this.updateOverviewPanel();
    }

    public X509Certificate[] getCertificateChain() {
        return this.certificateChain;
    }

    public X509Certificate getSelectedCertificate() {
        TableItem[] items;
        X509Certificate result = null;
        if (this.chainTable != null && !this.chainTable.isDisposed() && (items = this.chainTable.getSelection()) != null && items.length > 0) {
            result = (X509Certificate)items[0].getData();
        }
        return result;
    }

    public X509Certificate getSubjectCertificate() {
        return this.certificateChain != null && this.certificateChain.length > 0 ? this.certificateChain[0] : null;
    }

    public void setCertificate(X509Certificate cert) {
        this.setCertificateChain(new X509Certificate[]{cert});
    }

    public void setCertificateChain(X509Certificate[] chain) {
        this.certificateChain = chain;
        this.fillOverviewPanel();
        this.fillChainTable();
        this.fillDetailsTree();
    }

    protected void fillChainTable() {
        this.chainTable.removeAll();
        X509Certificate[] chain = this.getCertificateChain();
        if (chain != null) {
            X509Certificate[] x509CertificateArray = chain;
            int n = chain.length;
            int n2 = 0;
            while (n2 < n) {
                X509Certificate cert = x509CertificateArray[n2];
                TableItem item = new TableItem(this.chainTable, 0);
                item.setText(cert.getSubjectDN().getName());
                item.setData((Object)cert);
                ++n2;
            }
        }
        this.chainTable.setSelection(0);
    }

    protected void fillDetailsTree() {
        this.detailsTree.removeAll();
        this.valueText.setText("");
        X509Certificate certificate = this.getSelectedCertificate();
        if (certificate != null) {
            TreeItem certItem = new TreeItem(this.detailsTree, 0);
            certItem.setText("Certificate");
            TreeItem tbsItem = this.createTreeItem(certItem, "TBS Certificate", "");
            this.createTreeItem(tbsItem, "Version", String.valueOf(certificate.getVersion()));
            this.createTreeItem(tbsItem, "Serial Number", X509Util.formatSerialNumber((BigInteger)certificate.getSerialNumber()));
            this.createTreeItem(tbsItem, "Signature", certificate.getSigAlgName());
            this.createTreeItem(tbsItem, "Issuer", certificate.getIssuerX500Principal().getName());
            TreeItem validItem = this.createTreeItem(tbsItem, "Validity", "");
            this.createTreeItem(validItem, "Not Before", certificate.getNotBefore().toString());
            this.createTreeItem(validItem, "Not After", certificate.getNotAfter().toString());
            this.createTreeItem(tbsItem, "Subject", certificate.getSubjectX500Principal().getName());
            TreeItem subPubKeyInfoItem = this.createTreeItem(tbsItem, "Subject Public Key Info", "");
            this.createTreeItem(subPubKeyInfoItem, "Subject Public Key Algorithm", certificate.getPublicKey().getAlgorithm());
            this.createTreeItem(subPubKeyInfoItem, "Subject Public Key", X509Util.formatEncodedData((byte[])certificate.getPublicKey().getEncoded()));
            TreeItem extItem = this.createTreeItem(tbsItem, "Extensions", "");
            this.fillExtensions(extItem, certificate);
            TreeItem sigAlgItem = this.createTreeItem(certItem, "Signature Algorithm", certificate.getSigAlgName());
            TreeItem sigItem = this.createTreeItem(certItem, "Signature", X509Util.formatEncodedData((byte[])certificate.getSignature()));
            certItem.setExpanded(true);
            tbsItem.setExpanded(true);
            validItem.setExpanded(true);
            subPubKeyInfoItem.setExpanded(true);
            sigAlgItem.setExpanded(true);
            sigItem.setExpanded(true);
        }
    }

    private void fillExtensions(TreeItem extRoot, X509Certificate certificate) {
        this.fillExtensions(extRoot, certificate, true);
        this.fillExtensions(extRoot, certificate, false);
    }

    private void fillExtensions(TreeItem extRoot, X509Certificate certificate, boolean critical) {
        Set<String> oids = critical ? certificate.getCriticalExtensionOIDs() : certificate.getNonCriticalExtensionOIDs();
        for (String oid : oids) {
            TreeItem extItem = this.createTreeItem(extRoot, "Extensions", "");
            this.createTreeItem(extItem, "Extension ID", oid);
            this.createTreeItem(extItem, "Critical", Boolean.toString(critical));
            this.createTreeItem(extItem, "Extension Value", X509Util.formatEncodedData((byte[])certificate.getExtensionValue(oid)));
        }
    }

    protected void fillOverviewPanel() {
        boolean valid = false;
        X509Certificate certificate = this.getSubjectCertificate();
        try {
            certificate.checkValidity();
            valid = true;
        }
        catch (CertificateExpiredException certificateExpiredException) {
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {}
        Display display = Display.getDefault();
        this.validText.setText(valid ? "YES" : "NO");
        this.validText.setForeground(valid ? display.getSystemColor(5) : display.getSystemColor(3));
        this.notBeforeText.setText(certificate.getNotBefore().toString());
        this.notAfterText.setText(certificate.getNotAfter().toString());
        this.sNoText.setText(X509Util.formatSerialNumber((BigInteger)certificate.getSerialNumber()));
        this.notBeforeText.pack();
        this.notAfterText.pack();
        this.sNoText.pack();
        this.fillX500PrincipalLabels(certificate.getSubjectX500Principal(), this.subjectLabels);
        this.fillX500PrincipalLabels(certificate.getIssuerX500Principal(), this.issuerLabels);
        this.updateOverviewPanel();
    }

    private void fillX500PrincipalLabels(X500Principal principal, Hashtable<String, Label> table) {
        String[] parts;
        String name = principal.getName();
        String[] stringArray = parts = name.split("[,/]");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String key;
            Label label;
            String part = stringArray[n2];
            int index = part.indexOf("=");
            if (index >= 0 && (label = table.get(key = part.substring(0, index).trim().toUpperCase())) != null) {
                String value = part.substring(index + 1).trim();
                label.setText(value);
                label.pack();
            }
            ++n2;
        }
    }

    private TreeItem createTreeItem(TreeItem parent, String field, String value) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(field);
        item.setData((Object)value);
        return item;
    }

    private void createX500PrincipalGroup(Composite parent, String title, Hashtable<String, Label> table) {
        Group group = new Group(parent, 256);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText(title);
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        this.createX500PrincipalGroupContent(group, table);
    }

    private void createX500PrincipalGroupContent(Group group, Hashtable<String, Label> table) {
        table.put("CN", this.createX500PrincipalField(group, "Common name:"));
        table.put("O", this.createX500PrincipalField(group, "Organization:"));
        table.put("OU", this.createX500PrincipalField(group, "Organizational Unit:"));
        table.put("L", this.createX500PrincipalField(group, "Locality:"));
        table.put("ST", this.createX500PrincipalField(group, "State:"));
        table.put("C", this.createX500PrincipalField(group, "Country:"));
    }

    private Label createX500PrincipalField(Group group, String name) {
        Label nameLabel = new Label((Composite)group, 0);
        nameLabel.setText(name);
        Label valueLabel = new Label((Composite)group, 0);
        return valueLabel;
    }

    private void updateOverviewPanel() {
        Point size = this.overviewPanel.computeSize(-1, -1);
        this.overviewComp.setMinSize(size);
    }
}

