/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards;

import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.ui.widgets.GridConnectionDefinitionComposite;
import eu.geclipse.ui.wizards.Messages;
import java.net.URI;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ConnectionDefinitionWizardPage
extends WizardPage {
    private GridConnectionDefinitionComposite connectionDefinitionComp;
    private IGridContainer mountPoint;
    private URI initialURI;

    public ConnectionDefinitionWizardPage(IGridContainer mountPoint, URI uri) {
        super(Messages.getString("ConnectionDefinitionWizardPage.name"), Messages.getString("ConnectionDefinitionWizardPage.title"), null);
        this.mountPoint = mountPoint;
        this.initialURI = uri;
        this.setDescription(Messages.getString("ConnectionDefinitionWizardPage.description"));
    }

    public void createControl(Composite parent) {
        this.connectionDefinitionComp = new GridConnectionDefinitionComposite(this.mountPoint, parent, 0);
        if (this.initialURI != null) {
            this.connectionDefinitionComp.setURI(this.initialURI);
        }
        this.connectionDefinitionComp.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectionDefinitionWizardPage.this.validatePage();
            }
        });
        this.setControl((Control)this.connectionDefinitionComp);
    }

    public URI getURI() {
        return this.connectionDefinitionComp.getURI();
    }

    protected void validatePage() {
        URI uri = this.getURI();
        boolean valid = this.connectionDefinitionComp.isValid();
        this.setPageComplete(valid && uri != null);
        String errorMessage = this.connectionDefinitionComp.getErrorMessage();
        this.setErrorMessage(errorMessage);
    }
}

