/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IConnectionManager;
import eu.geclipse.core.model.IGridConnection;
import eu.geclipse.ui.wizards.Messages;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ConnectionNameWizardPage
extends WizardPage {
    private Text nameText;
    private String initialName;

    public ConnectionNameWizardPage(String initialName) {
        super(Messages.getString("ConnectionNameWizardPage.name"), Messages.getString("ConnectionNameWizardPage.title"), null);
        this.initialName = initialName;
        this.setDescription(Messages.getString("ConnectionNameWizardPage.description"));
    }

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(2, false));
        GridData gData = new GridData(1808);
        mainComp.setLayoutData((Object)gData);
        Label nameLabel = new Label(mainComp, 0);
        nameLabel.setText(Messages.getString("ConnectionNameWizardPage.name_label"));
        gData = new GridData();
        nameLabel.setLayoutData((Object)gData);
        this.nameText = new Text(mainComp, 2048);
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        this.nameText.setLayoutData((Object)gData);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectionNameWizardPage.this.validatePage();
            }
        });
        if (this.initialName != null) {
            this.nameText.setText(this.initialName);
        }
        this.setControl((Control)mainComp);
        this.validatePage();
    }

    public String getConnectionName() {
        return this.nameText.getText();
    }

    public void setConnectionName(String name) {
        this.nameText.setText(name);
    }

    protected boolean validatePage() {
        boolean valid = true;
        this.setErrorMessage(null);
        String name = this.getConnectionName();
        if (name != null && name.length() != 0) {
            IConnectionManager connectionManager = GridModel.getConnectionManager();
            IGridConnection[] gConnections = connectionManager.getGlobalConnections();
            if (gConnections != null) {
                IGridConnection[] iGridConnectionArray = gConnections;
                int n = gConnections.length;
                int n2 = 0;
                while (n2 < n) {
                    IGridConnection connection = iGridConnectionArray[n2];
                    if (connection.getName().equals(name)) {
                        this.setErrorMessage(Messages.getString("ConnectionNameWizardPage.connection_already_exists"));
                        valid = false;
                    }
                    ++n2;
                }
            }
        } else {
            valid = false;
        }
        this.setPageComplete(valid);
        return valid;
    }
}

