/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.impl.GenericVirtualOrganization;
import eu.geclipse.core.model.impl.GenericVoCreator;
import eu.geclipse.ui.internal.Activator;
import java.net.URL;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GenericVoWizardPage
extends WizardPage {
    private GenericVirtualOrganization initialVo;
    private Text nameText;
    private Pattern voNamePattern = Pattern.compile("^[\\w.-]+$");

    public GenericVoWizardPage() {
        super("genericVOPage", "Generic VO", null);
        this.setDescription("Specify the attributes of your VO");
        URL imgUrl = Activator.getDefault().getBundle().getEntry("icons/wizban/vo_wiz.gif");
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)imgUrl));
    }

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(mainComp, 0);
        nameLabel.setText("&VO Name:");
        GridData gData = new GridData();
        nameLabel.setLayoutData((Object)gData);
        this.nameText = new Text(mainComp, 2048);
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        this.nameText.setLayoutData((Object)gData);
        if (this.initialVo != null) {
            this.initVo(this.initialVo);
        }
        this.setControl((Control)mainComp);
    }

    public IStatus apply(GenericVoCreator creator) {
        IStatus result = Status.OK_STATUS;
        String name = this.nameText.getText();
        if (!this.validateVoName(name)) {
            result = new Status(4, "eu.geclipse.ui", "You have to specify a valid VO name");
        } else if (this.initialVo == null && GridModel.getVoManager().findChild(name) != null) {
            result = new Status(4, "eu.geclipse.ui", "A VO with the same name already exists");
        } else {
            creator.setVoName(name);
        }
        return result;
    }

    protected void initVo(GenericVirtualOrganization vo) {
        this.nameText.setText(vo != null ? vo.getName() : "");
        this.nameText.setEnabled(vo == null);
    }

    protected void setInitialVo(GenericVirtualOrganization vo) {
        this.initialVo = vo;
    }

    private boolean validateVoName(String voName) {
        return this.voNamePattern.matcher(voName).matches();
    }
}

