/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards;

import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.IGridService;
import eu.geclipse.core.model.impl.GenericVirtualOrganization;
import eu.geclipse.core.model.impl.GenericVoCreator;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ServiceDialog;
import eu.geclipse.ui.internal.Activator;
import java.net.URI;
import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class VoServiceSelectionPage
extends WizardPage {
    private static final String SERVICE_IMAGE = "icons/obj16/service_obj.gif";
    private static final String SERVICE_NEW_IMAGE = "icons/obj16/service_new_obj.gif";
    private static final String CONFIGURATION_DATA_KEY = "configuration";
    private static final String SERVICE_DATA_KEY = "service";
    private static final String URI_DATA_KEY = "uri";
    private static Hashtable<String, Image> images = new Hashtable();
    private GenericVirtualOrganization initialVo;
    private Table serviceTable;
    private Button addButton;
    private Button removeButton;

    public VoServiceSelectionPage() {
        super("voServiceSelectionPage", "Service Selection", null);
        this.setDescription("Add services to your VO");
        URL imgUrl = Activator.getDefault().getBundle().getEntry("icons/wizban/vo_wiz.gif");
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)imgUrl));
    }

    public IStatus apply(GenericVoCreator creator) {
        TableItem[] items;
        IStatus result = Status.OK_STATUS;
        TableItem[] tableItemArray = items = this.serviceTable.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                TableItem item = tableItemArray[n2];
                try {
                    IGridService service = (IGridService)item.getData(SERVICE_DATA_KEY);
                    IConfigurationElement element = (IConfigurationElement)item.getData(CONFIGURATION_DATA_KEY);
                    URI uri = (URI)item.getData(URI_DATA_KEY);
                    if (service != null) {
                        creator.maintainService(service);
                        break block4;
                    }
                    if (element == null || uri == null) break block4;
                    IGridElementCreator serviceCreator = (IGridElementCreator)element.createExecutableExtension("class");
                    creator.createService(serviceCreator, uri);
                }
                catch (Exception exc) {
                    result = new Status(4, "eu.geclipse.ui", exc.getLocalizedMessage(), (Throwable)exc);
                    break;
                }
            }
            ++n2;
        }
        return result;
    }

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayoutData((Object)new GridData(4, 4, true, true));
        mainComp.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(mainComp, 0);
        label.setText("Services");
        GridData labelData = new GridData(1, 0x1000000, false, false);
        labelData.horizontalSpan = 2;
        label.setLayoutData((Object)labelData);
        this.serviceTable = new Table(mainComp, 68354);
        this.serviceTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.serviceTable.setHeaderVisible(true);
        this.serviceTable.setLinesVisible(true);
        TableColumn typeColumn = new TableColumn(this.serviceTable, 0);
        typeColumn.setText("Type/Name");
        typeColumn.setWidth(150);
        TableColumn urlColumn = new TableColumn(this.serviceTable, 0);
        urlColumn.setText("Endpoint");
        urlColumn.setWidth(300);
        Composite buttonComp = new Composite(mainComp, 0);
        buttonComp.setLayoutData((Object)new GridData(1, 1, false, false));
        buttonComp.setLayout((Layout)new GridLayout(1, false));
        this.addButton = new Button(buttonComp, 0);
        this.addButton.setText("&Add...");
        this.addButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.removeButton = new Button(buttonComp, 0);
        this.removeButton.setText("&Remove");
        this.removeButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.serviceTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VoServiceSelectionPage.this.updateUI();
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VoServiceSelectionPage.this.showServiceDialog();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VoServiceSelectionPage.this.removeSelectedServices();
                VoServiceSelectionPage.this.updateUI();
            }
        });
        if (this.initialVo != null) {
            this.initVo(this.initialVo);
        }
        this.updateUI();
        this.setControl((Control)mainComp);
    }

    protected void initVo(GenericVirtualOrganization vo) {
        try {
            IGridElement[] children;
            IGridElement[] iGridElementArray = children = vo.getChildren(null);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IGridElement child = iGridElementArray[n2];
                if (child instanceof IGridService) {
                    IGridService service = (IGridService)child;
                    TableItem item = new TableItem(this.serviceTable, 0);
                    item.setText(0, service.getName());
                    item.setText(1, service.getURI().toString());
                    item.setImage(VoServiceSelectionPage.getImage(SERVICE_IMAGE));
                    item.setData(SERVICE_DATA_KEY, (Object)service);
                }
                ++n2;
            }
        }
        catch (ProblemException pExc) {
            Activator.logException(pExc);
        }
    }

    protected void removeSelectedServices() {
        int[] indices = this.serviceTable.getSelectionIndices();
        this.serviceTable.remove(indices);
    }

    protected void setInitialVo(GenericVirtualOrganization vo) {
        this.initialVo = vo;
    }

    protected void showServiceDialog() {
        ServiceDialog dialog = new ServiceDialog(this.getShell());
        if (dialog.open() == 0) {
            IConfigurationElement selectedElement = dialog.getSelectedElement();
            URI selectedURI = dialog.getSelectedURI();
            TableItem item = new TableItem(this.serviceTable, 0);
            item.setText(0, selectedElement.getAttribute("name"));
            item.setText(1, selectedURI.toString());
            item.setData(CONFIGURATION_DATA_KEY, (Object)selectedElement);
            item.setData(URI_DATA_KEY, (Object)selectedURI);
            item.setImage(VoServiceSelectionPage.getImage(SERVICE_NEW_IMAGE));
        }
    }

    protected static Image getImage(String name) {
        Image result = images.get(name);
        if (result == null) {
            URL url = Activator.getDefault().getBundle().getResource(name);
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            result = desc.createImage();
            images.put(name, result);
        }
        return result;
    }

    protected void updateUI() {
        boolean selected = this.serviceTable.getSelectionCount() > 0;
        this.removeButton.setEnabled(selected);
    }
}

