/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards.jobsubmission;

import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.core.model.IGridJobDescription;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.ui.internal.Activator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderSelectionWizardPage
extends WizardPage {
    IGridProject project;
    private Tree tree;
    private Text jobNameText;
    private List<IGridJobDescription> jobDescriptions;
    private TreeViewer treeViewer;

    public FolderSelectionWizardPage(String pageName, IGridProject project, List<IGridJobDescription> jobDescriptions) {
        super(pageName);
        super.setTitle("Submit job description");
        super.setDescription("Choose location and name for the job");
        this.project = project;
        this.jobDescriptions = jobDescriptions;
    }

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 3;
        gd.horizontalSpan = 2;
        gd.heightHint = 300;
        gd.widthHint = 250;
        this.treeViewer = new TreeViewer(mainComp, 2052);
        this.treeViewer.setContentProvider((IContentProvider)new RProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.treeViewer.setInput((Object)this.project.getParent().getResource());
        this.setTree(this.treeViewer.getTree());
        this.getTree().setLayoutData((Object)gd);
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FolderSelectionWizardPage.this.updateButtons();
            }
        });
        TreeItem[] treeItemArray = this.tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getData() instanceof IContainer) {
                this.tree.setSelection(item);
                break;
            }
            ++n2;
        }
        Label jobNameLabel = new Label(mainComp, 16384);
        jobNameLabel.setText("Job name");
        gd = new GridData();
        jobNameLabel.setLayoutData((Object)gd);
        this.jobNameText = new Text(mainComp, 18432);
        String name = this.jobDescriptions.get(0).getName();
        name = name.substring(0, name.indexOf("."));
        if (this.jobDescriptions.size() > 1) {
            this.jobNameText.setEnabled(false);
            String longName = "";
            for (IGridJobDescription jobDesc : this.jobDescriptions) {
                longName = String.valueOf(longName) + jobDesc.getName().substring(0, jobDesc.getName().indexOf(".")) + ", ";
            }
            longName = longName.substring(0, longName.lastIndexOf(","));
            this.jobNameText.setText(longName);
        } else {
            this.jobNameText.setText(name);
        }
        this.jobNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FolderSelectionWizardPage.this.updateButtons();
            }
        });
        gd = new GridData(768);
        this.jobNameText.setLayoutData((Object)gd);
        IGridContainer jobFolder = this.project.getProjectFolder(IGridJob.class);
        IResource jobFolderResource = jobFolder.getResource();
        this.treeViewer.expandToLevel(2);
        if (this.tree.getItems().length > 0) {
            TreeItem[] treeItemArray2 = this.tree.getItems()[0].getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem item = treeItemArray2[n4];
                if (item.getData() instanceof IContainer && item.getData().equals(jobFolderResource)) {
                    this.tree.setSelection(item);
                    break;
                }
                ++n4;
            }
        }
        this.setControl((Control)mainComp);
    }

    protected void updateButtons() {
        this.getContainer().updateButtons();
    }

    public boolean canFlipToNextPage() {
        boolean result = false;
        if (!this.jobNameText.getText().equals("") && this.getDestinationFolder() != null) {
            result = true;
        }
        return result;
    }

    private void setTree(Tree tree) {
        this.tree = tree;
    }

    public IResource getDestinationFolder() {
        IContainer result = null;
        TreeItem[] treeItemArray = this.tree.getSelection();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getData() instanceof IContainer) {
                result = (IContainer)item.getData();
            }
            ++n2;
        }
        return result;
    }

    public List<String> getJobNames() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.jobDescriptions.size() > 1) {
            for (IGridJobDescription jobDesc : this.jobDescriptions) {
                result.add(jobDesc.getName().substring(0, jobDesc.getName().indexOf(".")));
            }
        } else {
            String baseName = this.jobNameText.getText();
            int i = 1;
            String sufix = "";
            Iterator<IGridJobDescription> iterator = this.jobDescriptions.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                result.add(String.valueOf(baseName) + sufix);
                sufix = "_" + Integer.valueOf(i).toString();
                ++i;
            }
        }
        return result;
    }

    private Tree getTree() {
        return this.tree;
    }

    class RProvider
    implements ITreeContentProvider {
        RProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<IResource> list = new ArrayList<IResource>();
            if (parentElement instanceof IContainer) {
                try {
                    if (((IContainer)parentElement).members().length != 0) {
                        IResource[] iResourceArray = ((IContainer)parentElement).members();
                        int n = iResourceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource member = iResourceArray[n2];
                            if (member instanceof IProject) {
                                if (member.getName().equals(FolderSelectionWizardPage.this.project.getName())) {
                                    list.add(member);
                                }
                            } else if (member instanceof IContainer && !member.getName().startsWith(".")) {
                                list.add(member);
                            }
                            ++n2;
                        }
                    }
                }
                catch (CoreException e) {
                    Activator.logException(e);
                }
            }
            return list.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            boolean result = false;
            if (element instanceof IContainer) {
                try {
                    IResource[] iResourceArray = ((IContainer)element).members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource member = iResourceArray[n2];
                        if (member instanceof IProject) {
                            if (member.getName().equals(FolderSelectionWizardPage.this.project.getName())) {
                                result = true;
                                break;
                            }
                        } else if (member instanceof IContainer && !member.getName().startsWith(".")) {
                            result = true;
                            break;
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    Activator.logException(e);
                }
            }
            return result;
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<IResource> list = new ArrayList<IResource>();
            if (inputElement instanceof IContainer) {
                try {
                    if (((IContainer)inputElement).members().length != 0) {
                        IResource[] iResourceArray = ((IContainer)inputElement).members();
                        int n = iResourceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource member = iResourceArray[n2];
                            if (member instanceof IProject) {
                                if (member.getName().equals(FolderSelectionWizardPage.this.project.getName())) {
                                    list.add(member);
                                }
                            } else if (member instanceof IContainer && !member.getName().startsWith(".")) {
                                list.add(member);
                            }
                            ++n2;
                        }
                    }
                }
                catch (CoreException e) {
                    Activator.logException(e);
                }
            }
            return list.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

