/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards.wizardselection;

import eu.geclipse.ui.wizards.wizardselection.IWizardSelectionNode;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

class WizardSelectionListComposite
extends Composite {
    private Table table = null;
    private TableViewer tableViewer;
    private IWizardSelectionNode[] input;

    WizardSelectionListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String result = element instanceof IWizardSelectionNode ? ((IWizardSelectionNode)element).getName() : element.toString();
                return result;
            }

            public Image getImage(Object element) {
                Image result = null;
                if (element instanceof IWizardSelectionNode) {
                    result = ((IWizardSelectionNode)element).getIcon();
                }
                return result;
            }
        });
    }

    void addSelectionListener(SelectionListener listener) {
        this.table.addSelectionListener(listener);
    }

    void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.tableViewer.addSelectionChangedListener(listener);
    }

    private void initialize() {
        GridData tableGridData = new GridData();
        tableGridData.horizontalAlignment = 4;
        tableGridData.grabExcessHorizontalSpace = true;
        tableGridData.grabExcessVerticalSpace = true;
        tableGridData.verticalAlignment = 4;
        this.table = new Table((Composite)this, 2048);
        this.table.setLayoutData((Object)tableGridData);
        this.setSize(new Point(300, 200));
        this.setLayout((Layout)new GridLayout());
    }

    void fillWizardList(IWizardSelectionNode[] wizardSelectionNodes) {
        this.input = wizardSelectionNodes;
        this.tableViewer.add((Object[])wizardSelectionNodes);
    }

    void refreshList(IWizardSelectionNode[] newContent) {
        this.table.removeAll();
        this.fillWizardList(newContent);
    }
}

