/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.webview.views;

import eu.geclipse.webview.Activator;
import eu.geclipse.webview.views.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class WebView
extends ViewPart {
    protected Browser browser;
    protected String projectHomeUrl;
    protected String projectUserSupport;
    protected String projectVoms;
    private Action gEclipseHomeAction;
    private Action projectHomeAction;
    private Action ggusAction;
    private Action dgridAction;
    private Action back;
    private Action forward;
    private Action refresh;

    public void createPartControl(Composite parent) {
        this.updateUrlsFromPreferences();
        try {
            this.browser = new Browser(parent, 2048);
            this.browser.setUrl(this.projectHomeUrl);
            GridData gridData = new GridData(1808);
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            this.browser.setLayoutData((Object)gridData);
        }
        catch (SWTException swtException) {
            Status status = new Status(4, "eu.geclipse.webview", 0, Messages.WebView_initializeError, (Throwable)swtException);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        this.createActions();
        this.contributeToActionBars();
    }

    public void setFocus() {
    }

    public void setUrl(String url) {
        this.browser.setUrl(url);
    }

    public void setProjectUrl(String url) {
        Preferences prefs = Activator.getDefault().getPluginPreferences();
        prefs.setValue("Project Home URL", url);
        this.updateUrlsFromPreferences();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.gEclipseHomeAction);
        manager.add((IAction)this.projectHomeAction);
        manager.add((IAction)this.ggusAction);
        manager.add((IAction)this.dgridAction);
    }

    private void updateUrlsFromPreferences() {
        Preferences prefs = Activator.getDefault().getPluginPreferences();
        this.projectHomeUrl = prefs.getString("Project Home URL");
        this.projectUserSupport = prefs.getString("User Support URL");
        this.projectVoms = prefs.getString("Project VOMS URL");
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.refresh);
        manager.add((IAction)this.back);
        manager.add((IAction)this.forward);
    }

    private void createActions() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        ImageDescriptor image = sharedImages.getImageDescriptor("IMG_OBJS_INFO_TSK");
        this.gEclipseHomeAction = new Action(){

            public void run() {
                WebView.this.setUrl("http://www.geclipse.eu");
            }
        };
        this.gEclipseHomeAction.setText(Messages.WebView_g_eclipse);
        this.gEclipseHomeAction.setToolTipText(Messages.WebView_action_2_tooltip);
        this.gEclipseHomeAction.setImageDescriptor(image);
        this.projectHomeAction = new Action(){

            public void run() {
                WebView.this.setUrl(WebView.this.projectHomeUrl);
            }
        };
        this.projectHomeAction.setText(Messages.WebView_project_home);
        this.projectHomeAction.setToolTipText(Messages.WebView_action_2_tooltip);
        this.projectHomeAction.setImageDescriptor(image);
        this.ggusAction = new Action(){

            public void run() {
                WebView.this.setUrl(WebView.this.projectUserSupport);
            }
        };
        this.ggusAction.setText(Messages.WebView_GGUS);
        this.ggusAction.setToolTipText(Messages.WebView_GGUSshow);
        this.ggusAction.setImageDescriptor(image);
        this.dgridAction = new Action(){

            public void run() {
                WebView.this.setUrl(WebView.this.projectVoms);
            }
        };
        this.dgridAction.setText(Messages.WebView_VOMS);
        this.dgridAction.setToolTipText(Messages.WebView_VOMSshow);
        this.dgridAction.setImageDescriptor(image);
        this.back = new Action(){

            public void run() {
                WebView.this.browser.back();
            }
        };
        this.back.setText(Messages.WebView_back);
        this.back.setToolTipText(Messages.WebView_back);
        ImageDescriptor backImage = sharedImages.getImageDescriptor("IMG_TOOL_BACK");
        this.back.setImageDescriptor(backImage);
        this.forward = new Action(){

            public void run() {
                WebView.this.browser.forward();
            }
        };
        this.forward.setText(Messages.WebView_forward);
        this.forward.setToolTipText(Messages.WebView_forward);
        ImageDescriptor forwareImage = sharedImages.getImageDescriptor("IMG_TOOL_FORWARD");
        this.forward.setImageDescriptor(forwareImage);
        this.refresh = new Action(){

            public void run() {
                WebView.this.browser.refresh();
            }
        };
        this.refresh.setText(Messages.WebView_refresh);
        this.refresh.setToolTipText(Messages.WebView_refresh);
        ImageDescriptor refreshImage = sharedImages.getImageDescriptor("IMG_ETOOL_HOME_NAV");
        this.refresh.setImageDescriptor(refreshImage);
    }
}

