/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.edit.commands;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridRoot;
import eu.geclipse.jsdl.JSDLJobDescription;
import eu.geclipse.workflow.model.IWorkflowJob;
import eu.geclipse.workflow.ui.part.Messages;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;

public class CopyJobDescToWorkflowCommand
extends AbstractTransactionalCommand {
    private JSDLJobDescription jsdl;
    private EObject domainElt;

    public CopyJobDescToWorkflowCommand(EObject domainElt, JSDLJobDescription jsdl) {
        super(TransactionUtil.getEditingDomain((EObject)domainElt), Messages.getString("CopyJobDescToWorkflowCommand_constructorMessage"), null);
        this.domainElt = domainElt;
        this.jsdl = jsdl;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
        if (!(this.domainElt instanceof IWorkflowJob)) {
            return CommandResult.newErrorCommandResult((String)"Element is not a Workflow Job");
        }
        IResource jsdlRes = this.jsdl.getResource();
        IPath jsdlResPath = jsdlRes.getLocation();
        String jsdlResPathString = jsdlResPath.toString();
        java.net.URI jsdlResPathUri = URIUtil.toURI((String)jsdlResPathString);
        IFile jsdlSource = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(jsdlResPathUri)[0];
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.domainElt);
        ResourceSet resourceSet = domain.getResourceSet();
        EList resources = resourceSet.getResources();
        Resource workflowRes = (Resource)resources.get(0);
        URI workflowRootUri = workflowRes.getURI();
        String workflowRootPathString = workflowRootUri.path();
        String[] workflowDirectories = workflowRootPathString.split("/");
        String projectName = workflowDirectories[2];
        IGridRoot gridModelRoot = GridModel.getRoot();
        IFileStore gridModelRootFileStore = gridModelRoot.getFileStore();
        IFileStore workflowRootFileStore = gridModelRootFileStore.getChild(projectName);
        int numDirsInWorkflowPath = workflowDirectories.length;
        IFileStore fs = workflowRootFileStore;
        int i = 3;
        while (i < numDirsInWorkflowPath - 1) {
            String d = workflowDirectories[i];
            d = d.replace("%20", " ");
            fs = fs.getChild(d);
            ++i;
        }
        String jsdlSourceName = jsdlSource.getName();
        fs = fs.getChild(jsdlSourceName);
        java.net.URI jsdlTargetUri = fs.toURI();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IFile jsdlTarget = workspaceRoot.findFilesForLocationURI(jsdlTargetUri)[0];
        try {
            if (!jsdlTarget.equals((Object)jsdlSource)) {
                java.net.URI targetUri;
                int numDirs;
                String newTargetName;
                String targetNamePart;
                int numTarget = 0;
                while (jsdlTarget.exists()) {
                    targetNamePart = jsdlTarget.getName().split("\\.")[0];
                    newTargetName = "";
                    if (targetNamePart.endsWith(String.valueOf(numTarget))) {
                        targetNamePart = targetNamePart.substring(0, targetNamePart.length() - String.valueOf(numTarget).length());
                    }
                    newTargetName = String.valueOf(targetNamePart) + ++numTarget + ".jsdl";
                    numDirs = workflowDirectories.length;
                    targetUri = null;
                    IFileStore fs1 = workflowRootFileStore;
                    int i2 = 3;
                    while (i2 < numDirs - 1) {
                        String dir = workflowDirectories[i2];
                        dir = dir.replace("%20", " ");
                        fs1 = fs1.getChild(dir);
                        ++i2;
                    }
                    fs1 = fs1.getChild(newTargetName);
                    targetUri = fs1.toURI();
                    jsdlTarget = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(targetUri)[0];
                }
                if (numTarget > 0) {
                    targetNamePart = jsdlTarget.getName().split(String.valueOf(numTarget) + "\\.")[0];
                    newTargetName = String.valueOf(targetNamePart) + numTarget + ".jsdl";
                    numDirs = workflowDirectories.length;
                    targetUri = null;
                    fs = workflowRootFileStore;
                    int i3 = 3;
                    while (i3 < numDirs - 1) {
                        String dir = workflowDirectories[i3];
                        dir = dir.replace("%20", " ");
                        fs = fs.getChild(dir);
                        ++i3;
                    }
                    fs = fs.getChild(newTargetName);
                    targetUri = fs.toURI();
                    jsdlTarget = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(targetUri)[0];
                }
                jsdlSource.copy(jsdlTarget.getFullPath(), true, null);
            }
        }
        catch (CoreException coreException) {}
        String jsdlTargetName = jsdlTarget.getName();
        String jsdlTargetExtension = jsdlTarget.getFileExtension();
        String jsdlTargetSeparatorAndExtension = "." + jsdlTargetExtension;
        IWorkflowJob workflowJob = (IWorkflowJob)this.domainElt;
        workflowJob.setJobDescription(jsdlTargetName);
        int jsdlTargetLastPartIndex = jsdlTargetName.indexOf(jsdlTargetSeparatorAndExtension);
        workflowJob.setName(jsdlTarget.getName().substring(0, jsdlTargetLastPartIndex));
        return CommandResult.newOKCommandResult();
    }
}

