/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.edit.commands;

import eu.geclipse.workflow.model.IInputPort;
import eu.geclipse.workflow.model.ILink;
import eu.geclipse.workflow.model.IOutputPort;
import eu.geclipse.workflow.model.IWorkflow;
import eu.geclipse.workflow.model.IWorkflowFactory;
import eu.geclipse.workflow.model.IWorkflowPackage;
import eu.geclipse.workflow.ui.edit.policies.WorkflowBaseItemSemanticEditPolicy;
import eu.geclipse.workflow.ui.part.Messages;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;

public class LinkCreateCommand
extends CreateElementCommand {
    private final EObject source;
    private final EObject target;
    private IWorkflow container;

    public LinkCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super((CreateElementRequest)request);
        this.source = source;
        this.target = target;
        if (request.getContainmentFeature() == null) {
            this.setContainmentFeature(IWorkflowPackage.eINSTANCE.getIWorkflow_Links());
        }
        EObject element = source;
        while (element != null) {
            if (element instanceof IWorkflow) {
                this.container = (IWorkflow)element;
                super.setElementToEdit((EObject)this.container);
                break;
            }
            element = element.eContainer();
        }
    }

    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof IOutputPort)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof IInputPort)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        if (this.getContainer() == null) {
            return false;
        }
        return WorkflowBaseItemSemanticEditPolicy.LinkConstraints.canCreateILink_3001(this.getContainer(), this.getSource(), this.getTarget());
    }

    protected EObject doDefaultElementCreation() {
        ILink newElement = IWorkflowFactory.eINSTANCE.createILink();
        this.getContainer().getLinks().add((Object)newElement);
        newElement.setSource(this.getSource());
        newElement.setTarget(this.getTarget());
        return newElement;
    }

    protected EClass getEClassToEdit() {
        return IWorkflowPackage.eINSTANCE.getIWorkflow();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException(Messages.getString("LinkCreateCommand_InvalidArgumentsInCreateLink"));
        }
        return super.doExecuteWithResult(monitor, info);
    }

    protected ConfigureRequest createConfigureRequest() {
        ConfigureRequest request = super.createConfigureRequest();
        request.setParameter("CreateRelationshipRequest.source", (Object)this.getSource());
        request.setParameter("CreateRelationshipRequest.target", (Object)this.getTarget());
        return request;
    }

    protected void setElementToEdit(EObject element) {
        throw new UnsupportedOperationException();
    }

    protected IOutputPort getSource() {
        return (IOutputPort)this.source;
    }

    protected IInputPort getTarget() {
        return (IInputPort)this.target;
    }

    public IWorkflow getContainer() {
        return this.container;
    }
}

