/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.edit.commands;

import eu.geclipse.jsdl.JSDLJobDescription;
import eu.geclipse.workflow.model.IWorkflowJob;
import eu.geclipse.workflow.ui.edit.commands.InputPortAfterCreateCommand;
import eu.geclipse.workflow.ui.edit.commands.OutputPortAfterCreateCommand;
import eu.geclipse.workflow.ui.edit.parts.InputPortEditPart;
import eu.geclipse.workflow.ui.edit.parts.OutputPortEditPart;
import eu.geclipse.workflow.ui.edit.parts.WorkflowJobEditPart;
import eu.geclipse.workflow.ui.edit.policies.WorkflowJobItemSemanticEditPolicy;
import eu.geclipse.workflow.ui.part.Messages;
import eu.geclipse.workflow.ui.providers.WorkflowElementTypes;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.notation.Node;

public class UpdateJobPortsCommand
extends AbstractTransactionalCommand {
    private GraphicalEditPart editPart;
    private JSDLJobDescription jsdl;
    private EObject domainElt;

    public UpdateJobPortsCommand(GraphicalEditPart editPart, JSDLJobDescription jsdl) {
        super(TransactionUtil.getEditingDomain((EObject)editPart.resolveSemanticElement()), Messages.getString("UpdateJobPortsCommand_constructorMessage"), null);
        this.editPart = editPart;
        this.domainElt = editPart.resolveSemanticElement();
        this.jsdl = jsdl;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
        String uri;
        if (!(this.domainElt instanceof IWorkflowJob) | !(this.editPart instanceof WorkflowJobEditPart)) {
            return CommandResult.newErrorCommandResult((String)"Element is not a Workflow Job");
        }
        IResource jsdlRes = this.jsdl.getResource();
        IPath jsdlResPath = jsdlRes.getLocation();
        String jsdlResPathString = jsdlResPath.toString();
        URI jsdlResPathUri = URIUtil.toURI((String)jsdlResPathString);
        IFile jsdlFile = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(jsdlResPathUri)[0];
        this.jsdl = new JSDLJobDescription(jsdlFile);
        CompoundCommand cmd = new CompoundCommand();
        List childParts = this.editPart.getChildren();
        for (Object child : childParts) {
            OutputPortEditPart outputPortPart;
            InputPortEditPart inputPortPart;
            Command destroyCmd;
            if (child instanceof InputPortEditPart && (destroyCmd = this.destroyInputPortCommand(inputPortPart = (InputPortEditPart)((Object)child))) != null) {
                cmd.add(destroyCmd);
            }
            if (!(child instanceof OutputPortEditPart) || (destroyCmd = this.destroyOutputPortCommand(outputPortPart = (OutputPortEditPart)((Object)child))) == null) continue;
            cmd.add(destroyCmd);
        }
        Map m = this.jsdl.getDataStagingInStrings();
        Set s = m.keySet();
        for (String filename : s) {
            uri = (String)m.get(filename);
            cmd.add(this.createInputPortCommand(filename, uri));
        }
        m = this.jsdl.getDataStagingOutStrings();
        s = m.keySet();
        for (String filename : s) {
            uri = (String)m.get(filename);
            cmd.add(this.createOutputPortCommand(filename, uri));
        }
        cmd.execute();
        return CommandResult.newOKCommandResult();
    }

    private Command createInputPortCommand(String filename, String uri) {
        IElementType type = WorkflowElementTypes.IInputPort_2002;
        CreateViewAndElementRequest.ViewAndElementDescriptor viewDescriptor = new CreateViewAndElementRequest.ViewAndElementDescriptor(new CreateElementRequestAdapter(new CreateElementRequest(type)), Node.class, ((IHintedType)type).getSemanticHint(), this.editPart.getDiagramPreferencesHint());
        CreateViewAndElementRequest createRequest = new CreateViewAndElementRequest(viewDescriptor);
        Command cmd = this.editPart.getCommand((Request)createRequest);
        cmd = cmd.chain((Command)new InputPortAfterCreateCommand((IAdaptable)((Collection)createRequest.getNewObject()).iterator().next(), filename, uri, this.editPart.getEditingDomain()));
        return cmd;
    }

    private Command createOutputPortCommand(String filename, String uri) {
        IElementType type = WorkflowElementTypes.IOutputPort_2001;
        CreateViewAndElementRequest.ViewAndElementDescriptor viewDescriptor = new CreateViewAndElementRequest.ViewAndElementDescriptor(new CreateElementRequestAdapter(new CreateElementRequest(type)), Node.class, ((IHintedType)type).getSemanticHint(), this.editPart.getDiagramPreferencesHint());
        CreateViewAndElementRequest createRequest = new CreateViewAndElementRequest(viewDescriptor);
        Command cmd = this.editPart.getCommand((Request)createRequest);
        cmd = cmd.chain((Command)new OutputPortAfterCreateCommand((IAdaptable)((Collection)createRequest.getNewObject()).iterator().next(), filename, uri, this.editPart.getEditingDomain()));
        return cmd;
    }

    private Command destroyOutputPortCommand(OutputPortEditPart outputPortPart) {
        WorkflowJobItemSemanticEditPolicy semanticEditPolicy = (WorkflowJobItemSemanticEditPolicy)this.editPart.getEditPolicy((Object)"SemanticPolicy");
        Command cmd = semanticEditPolicy.getDestroyElementCommand(new DestroyElementRequest(outputPortPart.resolveSemanticElement(), false));
        return cmd;
    }

    private Command destroyInputPortCommand(InputPortEditPart inputPortPart) {
        WorkflowJobItemSemanticEditPolicy semanticEditPolicy = (WorkflowJobItemSemanticEditPolicy)this.editPart.getEditPolicy((Object)"SemanticPolicy");
        Command cmd = semanticEditPolicy.getDestroyElementCommand(new DestroyElementRequest(inputPortPart.resolveSemanticElement(), false));
        return cmd;
    }
}

