/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.edit.parts;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridRoot;
import eu.geclipse.jsdl.JSDLJobDescription;
import eu.geclipse.jsdl.ui.wizards.NewJobWizard;
import eu.geclipse.workflow.model.IWorkflowJob;
import eu.geclipse.workflow.ui.edit.commands.ClearJobDescPropertyCommand;
import eu.geclipse.workflow.ui.edit.commands.UpdateJobPortsCommand;
import eu.geclipse.workflow.ui.edit.parts.WorkflowJobNameEditPart;
import eu.geclipse.workflow.ui.edit.policies.WorkflowJobCanonicalEditPolicy;
import eu.geclipse.workflow.ui.edit.policies.WorkflowJobDragDropEditPolicy;
import eu.geclipse.workflow.ui.edit.policies.WorkflowJobItemSemanticEditPolicy;
import eu.geclipse.workflow.ui.internal.WorkflowDiagramEditorPlugin;
import eu.geclipse.workflow.ui.internal.WorkflowJobFigure;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.FlowLayoutEditPolicy;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class WorkflowJobEditPart
extends ShapeNodeEditPart {
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    String msg;
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected Collection<IResource> changedRes = new ArrayList<IResource>();
                    protected Collection<IResource> removedRes = new ArrayList<IResource>();

                    ResourceDeltaVisitor() {
                    }

                    public boolean visit(IResourceDelta visitDelta) throws CoreException {
                        IResource resource;
                        if (visitDelta.getFlags() != 131072 && visitDelta.getResource().getType() == 1 && (visitDelta.getKind() & 6) != 0 && (resource = visitDelta.getResource()) != null) {
                            if ((visitDelta.getKind() & 2) != 0) {
                                this.removedRes.add(resource);
                            } else if (!(this).WorkflowJobEditPart.this.savedResources.remove(resource)) {
                                this.changedRes.add(resource);
                            }
                        }
                        return true;
                    }

                    public Collection<IResource> getChangedResources() {
                        return this.changedRes;
                    }

                    public Collection<IResource> getRemovedResources() {
                        return this.removedRes;
                    }
                }
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                EObject o = WorkflowJobEditPart.this.resolveSemanticElement();
                if (o instanceof IWorkflowJob) {
                    IResource res1;
                    IFile[] workflowIFile;
                    java.net.URI uri;
                    String gridModelRootFileStoreString;
                    IFileStore gridModelRootFileStore;
                    IGridRoot gridModelRoot;
                    String wfFileString;
                    IWorkflowJob job = (IWorkflowJob)o;
                    Collection<IResource> changed = visitor.getChangedResources();
                    for (IResource res : changed) {
                        String loc = res.getLocation().toString();
                        String jobDesc = job.getJobDescription();
                        EObject wfContainer = job.eContainer();
                        wfFileString = EcoreUtil.getURI((EObject)wfContainer).toPlatformString(true);
                        gridModelRoot = GridModel.getRoot();
                        gridModelRootFileStore = gridModelRoot.getFileStore();
                        gridModelRootFileStoreString = gridModelRootFileStore.toString();
                        uri = URIUtil.toURI((String)(String.valueOf(gridModelRootFileStoreString) + wfFileString));
                        workflowIFile = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
                        res1 = workflowIFile[0].getParent().findMember(jobDesc);
                        String fileString = res1.getLocation().toString();
                        if (!loc.equals(fileString)) continue;
                        java.net.URI jsdlPathUri = URIUtil.toURI((String)fileString);
                        IFile jsdlFile = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(jsdlPathUri)[0];
                        JSDLJobDescription jsdl = new JSDLJobDescription(jsdlFile);
                        UpdateJobPortsCommand updatePortsCommand = new UpdateJobPortsCommand((GraphicalEditPart)WorkflowJobEditPart.this, jsdl);
                        try {
                            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)updatePortsCommand, (IProgressMonitor)new NullProgressMonitor(), null);
                        }
                        catch (ExecutionException executionException) {}
                    }
                    Collection<IResource> removed = visitor.getRemovedResources();
                    for (IResource res : removed) {
                        String loc = res.getLocation().toString();
                        String jobDesc = job.getJobDescription();
                        wfFileString = job.getWorkflow().eResource().getURI().toPlatformString(true);
                        gridModelRoot = GridModel.getRoot();
                        gridModelRootFileStore = gridModelRoot.getFileStore();
                        gridModelRootFileStoreString = gridModelRootFileStore.toString();
                        uri = URIUtil.toURI((String)(String.valueOf(gridModelRootFileStoreString) + wfFileString));
                        workflowIFile = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
                        res1 = workflowIFile[0].getParent().findMember(jobDesc);
                        IFile[] file = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(res1.getLocation());
                        if (!loc.equals(file.toString())) continue;
                        ClearJobDescPropertyCommand clearJobDescCmd = new ClearJobDescPropertyCommand(job);
                        try {
                            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)clearJobDescCmd, (IProgressMonitor)new NullProgressMonitor(), null);
                        }
                        catch (ExecutionException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (CoreException coreException) {}
        }
    };
    public static final int VISUAL_ID = 1001;
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public WorkflowJobEditPart(View view) {
        super(view);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationEditPolicy());
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new WorkflowJobItemSemanticEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new WorkflowJobDragDropEditPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new WorkflowJobCanonicalEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.removeEditPolicy("ConnectionHandlesPolicy");
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        FlowLayoutEditPolicy lep = new FlowLayoutEditPolicy(){

            protected Command createAddCommand(EditPart child, EditPart after) {
                return null;
            }

            protected Command createMoveChildCommand(EditPart child, EditPart after) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        WorkflowJobFigure figure = new WorkflowJobFigure();
        this.primaryShape = figure;
        return this.primaryShape;
    }

    public WorkflowJobFigure getPrimaryShape() {
        return (WorkflowJobFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof WorkflowJobNameEditPart) {
            ((WorkflowJobNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureWorkflowJobNameFigure());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, 1);
    }

    public void performRequest(Request request) {
        if (request.getType().equals("open")) {
            IWorkflowJob job = (IWorkflowJob)this.resolveSemanticElement();
            String filename = job.getJobDescription();
            if (filename != null) {
                if (!"".equals(filename)) {
                    String wfFileString = job.getWorkflow().eResource().getURI().toPlatformString(true);
                    IGridRoot gridModelRoot = GridModel.getRoot();
                    IFileStore gridModelRootFileStore = gridModelRoot.getFileStore();
                    String gridModelRootFileStoreString = gridModelRootFileStore.toString();
                    java.net.URI uri = URIUtil.toURI((String)(String.valueOf(gridModelRootFileStoreString) + wfFileString));
                    IFile[] workflowIFile = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
                    IResource res = workflowIFile[0].getParent().findMember(filename);
                    IFile[] file = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(res.getLocation());
                    try {
                        if (file.length != 0 && file[0].exists()) {
                            IDE.openEditor((IWorkbenchPage)WorkflowDiagramEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file[0], (boolean)true);
                        }
                    }
                    catch (PartInitException partInitException) {
                        WorkflowDiagramEditorPlugin.logException(partInitException);
                    }
                } else {
                    this.createNewJobWizard();
                }
            } else {
                this.createNewJobWizard();
            }
        }
        super.performRequest(request);
    }

    private void createNewJobWizard() {
        NewJobWizard newJobWizard = new NewJobWizard();
        TransactionalEditingDomain domain = this.getEditingDomain();
        ResourceSet resourceSet = domain.getResourceSet();
        Resource res = (Resource)resourceSet.getResources().get(0);
        URI wfRootUri = res.getURI();
        String wfRootPath = wfRootUri.path();
        String[] dirs = wfRootPath.split("/");
        String projectName = dirs[2];
        IFileStore wfRootFileStore = GridModel.getRoot().getFileStore().getChild(projectName).getChild("Workflows");
        newJobWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)wfRootFileStore));
        WizardDialog wizard = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)newJobWizard);
        wizard.create();
        wizard.open();
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        return super.getContentPaneFor(editPart);
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(this.getMapMode().DPtoLP(100), this.getMapMode().DPtoLP(50));
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }
}

