/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.edit.policies;

import eu.geclipse.jsdl.JSDLJobDescription;
import eu.geclipse.workflow.model.IWorkflowJob;
import eu.geclipse.workflow.ui.edit.commands.CopyJobDescToWorkflowCommand;
import eu.geclipse.workflow.ui.edit.commands.UpdateJobPortsCommand;
import eu.geclipse.workflow.ui.edit.parts.WorkflowJobEditPart;
import eu.geclipse.workflow.ui.part.Messages;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;

public class WorkflowJobDragDropEditPolicy
extends DragDropEditPolicy {
    private WorkflowJobEditPart selectedElement = null;

    public Command getDropObjectsCommand(DropObjectsRequest dropRequest) {
        List objects = dropRequest.getObjects();
        CompoundCommand cmd = new CompoundCommand();
        JSDLJobDescription jsdl = null;
        Iterator iterator = objects.iterator();
        if (iterator.hasNext()) {
            Object o = iterator.next();
            if (o instanceof JSDLJobDescription) {
                jsdl = (JSDLJobDescription)o;
                this.selectedElement = (WorkflowJobEditPart)this.getHost();
                IWorkflowJob selectedJob = (IWorkflowJob)this.selectedElement.resolveSemanticElement();
                CopyJobDescToWorkflowCommand copyCmd = new CopyJobDescToWorkflowCommand(this.selectedElement.resolveSemanticElement(), jsdl);
                UpdateJobPortsCommand updatePortsCmd = new UpdateJobPortsCommand((GraphicalEditPart)this.selectedElement, jsdl);
                if (selectedJob.getName() != null || selectedJob.getJobDescription() != null) {
                    MessageDialog confirmDialog = new MessageDialog(null, Messages.getString("WorkflowJobDragDropEditPolicy_confirmationTitle"), null, Messages.getString("WorkflowJobDragDropEditPolicy_userPrompt"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                    int result = confirmDialog.open();
                    if (result == 0) {
                        cmd.add((Command)new ICommandProxy((ICommand)copyCmd));
                        cmd.add((Command)new ICommandProxy((ICommand)updatePortsCmd));
                    }
                } else {
                    cmd.add((Command)new ICommandProxy((ICommand)copyCmd));
                    cmd.add((Command)new ICommandProxy((ICommand)updatePortsCmd));
                }
            }
            return cmd;
        }
        return super.getDropObjectsCommand(dropRequest);
    }
}

