/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.internal.actions;

import eu.geclipse.workflow.model.IInputPort;
import eu.geclipse.workflow.model.IOutputPort;
import eu.geclipse.workflow.model.IWorkflowJob;
import eu.geclipse.workflow.ui.edit.commands.ClearLinksCommand;
import eu.geclipse.workflow.ui.edit.parts.InputPortEditPart;
import eu.geclipse.workflow.ui.edit.parts.OutputPortEditPart;
import eu.geclipse.workflow.ui.edit.parts.WorkflowEditPart;
import eu.geclipse.workflow.ui.edit.parts.WorkflowJobEditPart;
import eu.geclipse.workflow.ui.providers.WorkflowElementTypes;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class CalculateJobDependenciesAction
implements IObjectActionDelegate {
    protected WorkflowEditPart mySelectedElement;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        WorkflowEditPart diagramPart = this.mySelectedElement;
        List jobParts = diagramPart.getChildren();
        for (WorkflowJobEditPart editPart : jobParts) {
            ClearLinksCommand clearLinksCmd = new ClearLinksCommand(editPart);
            try {
                OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)clearLinksCmd, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        for (WorkflowJobEditPart jobPart1 : jobParts) {
            IWorkflowJob job1 = (IWorkflowJob)jobPart1.resolveSemanticElement();
            for (WorkflowJobEditPart jobPart2 : jobParts) {
                IWorkflowJob job2 = (IWorkflowJob)jobPart2.resolveSemanticElement();
                EList inputs = job1.getInputs();
                EList outputs = job2.getOutputs();
                for (IInputPort inputPort : inputs) {
                    for (IOutputPort outputPort : outputs) {
                        if (!inputPort.getName().equals(outputPort.getName())) continue;
                        EditPart inputPortEditPart = jobPart1.findEditPart((EditPart)jobPart1, (EObject)inputPort);
                        EditPart outputPortEditPart = jobPart2.findEditPart((EditPart)jobPart2, (EObject)outputPort);
                        if (!(outputPortEditPart instanceof OutputPortEditPart) || !(inputPortEditPart instanceof InputPortEditPart)) continue;
                        IElementType type = WorkflowElementTypes.ILink_3001;
                        Command linkCreateCmd = CreateConnectionViewAndElementRequest.getCreateCommand((CreateConnectionViewAndElementRequest)new CreateConnectionViewAndElementRequest(type, ((IHintedType)type).getSemanticHint(), this.mySelectedElement.getDiagramPreferencesHint()), (EditPart)((OutputPortEditPart)outputPortEditPart), (EditPart)((InputPortEditPart)inputPortEditPart));
                        linkCreateCmd.execute();
                    }
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        this.mySelectedElement = null;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && structuredSelection.getFirstElement() instanceof WorkflowEditPart) {
            this.mySelectedElement = (WorkflowEditPart)((Object)structuredSelection.getFirstElement());
        }
        action.setEnabled(this.isEnabled());
    }

    private boolean isEnabled() {
        return this.mySelectedElement != null;
    }
}

