/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.part;

import eu.geclipse.workflow.model.IWorkflow;
import eu.geclipse.workflow.model.IWorkflowPackage;
import eu.geclipse.workflow.ui.internal.WorkflowDiagramEditorPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class WorkflowVisualIDRegistry {
    private static final String DEBUG_KEY = String.valueOf(WorkflowDiagramEditorPlugin.getInstance().getBundle().getSymbolicName()) + "/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("Workflow".equals(view.getType())) {
                return 79;
            }
            return -1;
        }
        return WorkflowVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                WorkflowDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (IWorkflowPackage.eINSTANCE.getIWorkflow().isSuperTypeOf(domainElement.eClass()) && WorkflowVisualIDRegistry.isDiagram((IWorkflow)domainElement)) {
            return 79;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        if (domainElement == null || !"Workflow".equals(WorkflowVisualIDRegistry.getModelID(containerView))) {
            return -1;
        }
        switch (WorkflowVisualIDRegistry.getVisualID(containerView)) {
            case 1001: {
                if (IWorkflowPackage.eINSTANCE.getIOutputPort().isSuperTypeOf(domainElement.eClass())) {
                    return 2001;
                }
                if (!IWorkflowPackage.eINSTANCE.getIInputPort().isSuperTypeOf(domainElement.eClass())) break;
                return 2002;
            }
            case 79: {
                if (!IWorkflowPackage.eINSTANCE.getIWorkflowJob().isSuperTypeOf(domainElement.eClass())) break;
                return 1001;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = WorkflowVisualIDRegistry.getModelID(containerView);
        if (!"Workflow".equals(containerModelID)) {
            return false;
        }
        if ("Workflow".equals(containerModelID)) {
            containerVisualID = WorkflowVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 79;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1001: {
                if (4001 == nodeVisualID) {
                    return true;
                }
                if (4002 == nodeVisualID) {
                    return true;
                }
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2002 != nodeVisualID) break;
                return true;
            }
            case 79: {
                if (1001 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (IWorkflowPackage.eINSTANCE.getILink().isSuperTypeOf(domainElement.eClass())) {
            return 3001;
        }
        return -1;
    }

    private static boolean isDiagram(IWorkflow element) {
        return true;
    }
}

