/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.wizards;

import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.workflow.IGridWorkflowDescription;
import eu.geclipse.workflow.ui.internal.WorkflowDiagramEditorPlugin;
import eu.geclipse.workflow.ui.part.Messages;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateFolderOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.misc.ResourceAndContainerGroup;

public class NewWorkflowCreationWizardPage
extends WizardPage
implements Listener {
    private static final int SIZING_CONTAINER_GROUP_HEIGHT = 250;
    private String extension = "workflow";
    private String initialName = "new";
    private URI linkTargetPath;
    private IStructuredSelection currentSelection;
    private IPath initialContainerFullPath;
    private ResourceAndContainerGroup resourceGroup;
    private IFolder newFolder;

    protected NewWorkflowCreationWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        URL imgUrl = WorkflowDiagramEditorPlugin.getDefault().getBundle().getEntry("icons/wizban/NewWorkflowWizard.gif");
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)imgUrl));
        this.currentSelection = selection;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        topLevel.setFont(parent.getFont());
        topLevel.setLayout((Layout)new GridLayout());
        topLevel.setLayoutData((Object)new GridData(272));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)topLevel, "eu.geclipse.workflow.uinew_workflow_wizard_page_context");
        this.resourceGroup = new ResourceAndContainerGroup(topLevel, (Listener)this, Messages.getString("NewWorkflowCreationWizardPage_WorkflowName"), Messages.getString("NewWorkflowCreationWizardPage_WorkflowNameLabel"), false, 250);
        this.resourceGroup.setAllowExistingResources(false);
        this.initializePage();
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)topLevel);
        this.setFileName(this.getUniqueFileName());
        this.resourceGroup.setFocus();
    }

    private String getUniqueFileName() {
        IPath containerFullPath = this.getContainerFullPath();
        String fileName = this.initialName;
        if (containerFullPath == null) {
            containerFullPath = new Path("");
        }
        if (fileName == null || fileName.trim().length() == 0) {
            fileName = "default";
        }
        IPath filePath = containerFullPath.append(fileName);
        if (this.extension != null && !this.extension.equals(filePath.getFileExtension())) {
            filePath = filePath.addFileExtension(this.extension);
        }
        this.extension = filePath.getFileExtension();
        fileName = filePath.removeFileExtension().lastSegment();
        int i = 0;
        while (ResourcesPlugin.getWorkspace().getRoot().exists(filePath)) {
            filePath = containerFullPath.append(String.valueOf(fileName) + ++i);
            if (this.extension == null) continue;
            filePath = filePath.addFileExtension(this.extension);
        }
        return filePath.lastSegment();
    }

    protected IFolder createFolderHandle(IPath folderPath) {
        return IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getFolder(folderPath);
    }

    public IFolder createNewFolder() {
        if (this.newFolder != null) {
            return this.newFolder;
        }
        IPath containerPath = this.resourceGroup.getContainerFullPath();
        IPath newFolderPath = containerPath.append(this.resourceGroup.getResource());
        final IFolder newFolderHandle = this.createFolderHandle(newFolderPath);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                CreateFolderOperation op = new CreateFolderOperation(newFolderHandle, NewWorkflowCreationWizardPage.this.linkTargetPath, IDEWorkbenchMessages.WizardNewFolderCreationPage_title);
                try {
                    PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)NewWorkflowCreationWizardPage.this.getShell()));
                }
                catch (ExecutionException e) {
                    NewWorkflowCreationWizardPage.this.getContainer().getShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            if (e.getCause() instanceof CoreException) {
                                ErrorDialog.openError((Shell)NewWorkflowCreationWizardPage.this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFolderCreationPage_errorTitle, null, (IStatus)((CoreException)e.getCause()).getStatus());
                            } else {
                                IDEWorkbenchPlugin.log(this.getClass(), (String)"createNewFolder()", (Throwable)e.getCause());
                                MessageDialog.openError((Shell)NewWorkflowCreationWizardPage.this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFolderCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFolder_internalError, (Object)e.getCause().getMessage()));
                            }
                        }
                    });
                }
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            IDEWorkbenchPlugin.log(((Object)((Object)this)).getClass(), (String)"createNewFolder()", (Throwable)e.getTargetException());
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFolderCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFolder_internalError, (Object)e.getTargetException().getMessage()));
            return null;
        }
        this.newFolder = newFolderHandle;
        return this.newFolder;
    }

    public IPath getContainerFullPath() {
        return this.resourceGroup.getContainerFullPath();
    }

    public String getFolderName() {
        if (this.resourceGroup == null) {
            return this.initialName;
        }
        return this.resourceGroup.getResource();
    }

    protected IPath getFolderPath() {
        String fileName;
        IPath path = this.getContainerFullPath();
        if (path == null) {
            path = new Path("");
        }
        if ((fileName = this.getFolderName()) != null) {
            path = path.append(fileName);
        }
        return path;
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.validatePage());
    }

    protected void initializePage() {
        Object o = this.currentSelection.getFirstElement();
        if (o instanceof IGridContainer) {
            IGridElement e = (IGridElement)o;
            IGridProject project = e.getProject();
            IPath path = null;
            if (project != null) {
                IGridContainer workflows = project.getProjectFolder(IGridWorkflowDescription.class);
                path = workflows != null ? workflows.getPath() : project.getPath();
            }
            this.resourceGroup.setContainerFullPath(path);
        }
        this.setPageComplete(false);
    }

    public void setContainerFullPath(IPath path) {
        if (this.resourceGroup == null) {
            this.initialContainerFullPath = path;
        } else {
            this.resourceGroup.setContainerFullPath(path);
        }
    }

    public void setFileExtension(String value) {
        if (this.resourceGroup == null) {
            this.extension = value;
        } else {
            this.resourceGroup.setResourceExtension(value);
        }
    }

    public void setFileName(String value) {
        if (this.resourceGroup == null) {
            this.initialName = value;
        } else {
            this.resourceGroup.setResource(value);
        }
    }

    protected boolean validatePage() {
        boolean valid = true;
        if (!this.resourceGroup.areAllValuesValid()) {
            if (this.resourceGroup.getProblemType() == 1 || this.resourceGroup.getProblemType() == 5) {
                this.setMessage(this.resourceGroup.getProblemMessage());
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(this.resourceGroup.getProblemMessage());
            }
            valid = false;
        }
        String resourceName = this.resourceGroup.getResource();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validateName(resourceName, 1);
        if (!result.isOK()) {
            this.setErrorMessage(result.getMessage());
            return false;
        }
        Object linkedResourceStatus = null;
        if (valid && (linkedResourceStatus == null || linkedResourceStatus.isOK())) {
            this.setMessage(null);
            this.setErrorMessage(null);
            if (this.resourceGroup.getAllowExistingResources()) {
                String problemMessage = NLS.bind((String)IDEWorkbenchMessages.ResourceGroup_nameExists, (Object)this.getFolderName());
                IPath resourcePath = this.getContainerFullPath().append(this.getFolderName());
                if (workspace.getRoot().getFolder(resourcePath).exists()) {
                    this.setErrorMessage(problemMessage);
                    valid = false;
                }
                if (workspace.getRoot().getFile(resourcePath).exists()) {
                    this.setMessage(problemMessage, 2);
                }
            }
        }
        if (this.extension != null && !this.getFolderPath().toString().endsWith("." + this.extension)) {
            this.setErrorMessage(NLS.bind((String)"Folder name should have ''{0}'' extension.", (Object)this.extension));
            valid = false;
        }
        return valid;
    }
}

