/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.common;

import com.xerox.amazonws.common.AWSConnection;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;

public class AWSAuthConnection
extends AWSConnection {
    public AWSAuthConnection(String awsAccessId, String awsSecretKey, boolean isSecure, String server, int port) {
        super(awsAccessId, awsSecretKey, isSecure, server, port);
    }

    protected HttpURLConnection makeRequest(String method, String resource, Map headers) throws MalformedURLException, IOException {
        URL url = this.makeURL(resource);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        this.addHeaders(connection, headers);
        this.addAuthHeader(connection, method, resource);
        return connection;
    }

    private void addHeaders(HttpURLConnection connection, Map headers) {
        this.addHeaders(connection, headers, "");
    }

    private void addMetadataHeaders(HttpURLConnection connection, Map metadata) {
        this.addHeaders(connection, metadata, "x-amz-meta-");
    }

    private void addHeaders(HttpURLConnection connection, Map headers, String prefix) {
        if (headers != null) {
            for (String key : headers.keySet()) {
                for (String value : (List)headers.get(key)) {
                    connection.addRequestProperty(String.valueOf(prefix) + key, value);
                }
            }
        }
    }

    private void addAuthHeader(HttpURLConnection connection, String method, String resource) {
        if (connection.getRequestProperty("Date") == null) {
            connection.setRequestProperty("Date", AWSAuthConnection.httpDate());
        }
        if (connection.getRequestProperty("Content-Type") == null) {
            connection.setRequestProperty("Content-Type", "");
        }
        String canonicalString = this.makeCanonicalString(method, resource, connection.getRequestProperties());
        String encodedCanonical = this.encode(this.getSecretAccessKey(), canonicalString, false);
        connection.setRequestProperty("Authorization", "AWS " + this.getAwsAccessKeyId() + ":" + encodedCanonical);
    }

    private String makeCanonicalString(String method, String resource, Map headers) {
        return this.makeCanonicalString(method, resource, headers, null);
    }

    private String makeCanonicalString(String method, String resource, Map headers, String expires) {
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(method) + "\n");
        TreeMap<String, String> interestingHeaders = new TreeMap<String, String>();
        if (headers != null) {
            for (String key : headers.keySet()) {
                String lk;
                if (key == null || !(lk = key.toLowerCase()).equals("content-type") && !lk.equals("content-md5") && !lk.equals("date") && !lk.startsWith("x-amz-")) continue;
                List s = (List)headers.get(key);
                interestingHeaders.put(lk, this.concatenateList(s));
            }
        }
        if (interestingHeaders.containsKey("x-amz-date")) {
            interestingHeaders.put("date", "");
        }
        if (expires != null) {
            interestingHeaders.put("date", expires);
        }
        if (!interestingHeaders.containsKey("content-type")) {
            interestingHeaders.put("content-type", "");
        }
        if (!interestingHeaders.containsKey("content-md5")) {
            interestingHeaders.put("content-md5", "");
        }
        for (String key : interestingHeaders.keySet()) {
            if (key.startsWith("x-amz-")) {
                buf.append(key).append(':').append(interestingHeaders.get(key));
            } else {
                buf.append(interestingHeaders.get(key));
            }
            buf.append("\n");
        }
        int queryIndex = resource.indexOf(63);
        if (queryIndex == -1) {
            buf.append("/" + resource);
        } else {
            buf.append("/" + resource.substring(0, queryIndex));
        }
        if (resource.matches(".*[&?]acl($|=|&).*")) {
            buf.append("?acl");
        } else if (resource.matches(".*[&?]torrent($|=|&).*")) {
            buf.append("?torrent");
        }
        return buf.toString();
    }

    private String concatenateList(List values) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        int size = values.size();
        while (i < size) {
            buf.append(((String)values.get(i)).replaceAll("\n", "").trim());
            if (i != size - 1) {
                buf.append(",");
            }
            ++i;
        }
        return buf.toString();
    }

    private static String httpDate() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss ", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return String.valueOf(format.format(new Date())) + "GMT";
    }
}

