/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.common;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public abstract class AWSConnection {
    private String awsAccessId;
    private String awsSecretKey;
    private boolean isSecure;
    private String server;
    private int port;
    protected Map<String, List<String>> headers;
    private static Mac mac;
    private static String lastSecretKey;

    public AWSConnection(String awsAccessId, String awsSecretKey, boolean isSecure, String server, int port) {
        this.awsAccessId = awsAccessId;
        this.awsSecretKey = awsSecretKey;
        this.isSecure = isSecure;
        this.server = server;
        this.port = port;
        this.headers = new TreeMap<String, List<String>>();
    }

    public URL getUrl() {
        try {
            return this.makeURL("");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    protected String getAwsAccessKeyId() {
        return this.awsAccessId;
    }

    protected String getSecretAccessKey() {
        return this.awsSecretKey;
    }

    protected boolean isSecure() {
        return this.isSecure;
    }

    protected String getServer() {
        return this.server;
    }

    protected int getPort() {
        return this.port;
    }

    protected URL makeURL(String resource) throws MalformedURLException {
        String protocol = this.isSecure ? "https" : "http";
        return new URL(protocol, this.server, this.port, "/" + resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String encode(String awsSecretKey, String canonicalString, boolean urlencode) {
        SecretKeySpec signingKey = new SecretKeySpec(awsSecretKey.getBytes(), "HmacSHA1");
        if (mac == null || !lastSecretKey.equals(awsSecretKey)) {
            try {
                mac = Mac.getInstance("HmacSHA1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Could not find sha1 algorithm", e);
            }
            try {
                mac.init(signingKey);
            }
            catch (InvalidKeyException e) {
                mac = null;
                throw new RuntimeException("Could not initialize the MAC algorithm", e);
            }
            lastSecretKey = awsSecretKey;
        }
        byte[] signedBytes = null;
        Mac mac = AWSConnection.mac;
        synchronized (mac) {
            signedBytes = AWSConnection.mac.doFinal(canonicalString.getBytes());
        }
        String b64 = new String(Base64.encodeBase64((byte[])signedBytes));
        if (urlencode) {
            return this.urlencode(b64);
        }
        return b64;
    }

    protected String urlencode(String unencoded) {
        try {
            return URLEncoder.encode(unencoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not url encode to UTF-8", e);
        }
    }
}

