/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.devpay;

import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.devpay.DesktopProductInfo;
import com.xerox.amazonws.devpay.DevPayException;
import com.xerox.amazonws.devpay.HostedProductInfo;
import com.xerox.amazonws.typica.jaxb.ActivateDesktopProductResponse;
import com.xerox.amazonws.typica.jaxb.ActivateDesktopProductResult;
import com.xerox.amazonws.typica.jaxb.ActivateHostedProductResponse;
import com.xerox.amazonws.typica.jaxb.ActivateHostedProductResult;
import com.xerox.amazonws.typica.jaxb.GetActiveSubscriptionsByPidResponse;
import com.xerox.amazonws.typica.jaxb.GetActiveSubscriptionsByPidResult;
import com.xerox.amazonws.typica.jaxb.RefreshUserTokenResponse;
import com.xerox.amazonws.typica.jaxb.RefreshUserTokenResult;
import com.xerox.amazonws.typica.jaxb.VerifyProductSubscriptionByPidResponse;
import com.xerox.amazonws.typica.jaxb.VerifyProductSubscriptionByPidResult;
import com.xerox.amazonws.typica.jaxb.VerifyProductSubscriptionByTokensResponse;
import com.xerox.amazonws.typica.jaxb.VerifyProductSubscriptionByTokensResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DevPayLS
extends AWSQueryConnection {
    private static Log logger = LogFactory.getLog(DevPayLS.class);

    public DevPayLS(String awsAccessId, String awsSecretKey) {
        this(awsAccessId, awsSecretKey, true);
    }

    public DevPayLS(String awsAccessId, String awsSecretKey, boolean isSecure) {
        this(awsAccessId, awsSecretKey, isSecure, "ls.amazonaws.com");
    }

    public DevPayLS(String awsAccessId, String awsSecretKey, boolean isSecure, String server) {
        this(awsAccessId, awsSecretKey, isSecure, server, isSecure ? 443 : 80);
    }

    public DevPayLS(String awsAccessId, String awsSecretKey, boolean isSecure, String server, int port) {
        super(awsAccessId, awsSecretKey, isSecure, server, port);
        DevPayLS.setVersionHeader(this);
    }

    @Override
    public int getSignatureVersion() {
        return super.getSignatureVersion();
    }

    @Override
    public void setSignatureVersion(int version) {
        super.setSignatureVersion(version);
    }

    public DesktopProductInfo activateDesktopProduct(String activationKey, String productToken) throws DevPayException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ActivationKey", activationKey);
        params.put("ProductToken", productToken);
        GetMethod method = new GetMethod();
        try {
            ActivateDesktopProductResponse response = this.makeRequest((HttpMethodBase)method, "ActivateDesktopProduct", params, ActivateDesktopProductResponse.class);
            ActivateDesktopProductResult result = response.getActivateDesktopProductResult();
            DesktopProductInfo desktopProductInfo = new DesktopProductInfo(result.getAWSAccessKeyId(), result.getSecretAccessKey(), result.getUserToken());
            return desktopProductInfo;
        }
        catch (JAXBException ex) {
            throw new DevPayException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (HttpException ex) {
            throw new DevPayException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new DevPayException(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public HostedProductInfo activateHostedProduct(String activationKey, String productToken) throws DevPayException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ActivationKey", activationKey);
        params.put("ProductToken", productToken);
        GetMethod method = new GetMethod();
        try {
            ActivateHostedProductResponse response = this.makeRequest((HttpMethodBase)method, "ActivateHostedProduct", params, ActivateHostedProductResponse.class);
            ActivateHostedProductResult result = response.getActivateHostedProductResult();
            HostedProductInfo hostedProductInfo = new HostedProductInfo(result.getPersistentIdentifier(), result.getUserToken());
            return hostedProductInfo;
        }
        catch (JAXBException ex) {
            throw new DevPayException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (HttpException ex) {
            throw new DevPayException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new DevPayException(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public List<String> getActiveSubscriptionsByPid(String persistentIdentifier) throws DevPayException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("PersistentIdentifier", persistentIdentifier);
        GetMethod method = new GetMethod();
        try {
            GetActiveSubscriptionsByPidResponse response = this.makeRequest((HttpMethodBase)method, "GetActiveSubscriptionsByPid", params, GetActiveSubscriptionsByPidResponse.class);
            GetActiveSubscriptionsByPidResult result = response.getGetActiveSubscriptionsByPidResult();
            List<String> list = result.getProductCodes();
            return list;
        }
        catch (JAXBException ex) {
            throw new DevPayException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (HttpException ex) {
            throw new DevPayException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new DevPayException(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public boolean isProductSubscribedByPid(String persistentIdentifier, String productCode) throws DevPayException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("PersistentIdentifier", persistentIdentifier);
        params.put("ProductCode", productCode);
        GetMethod method = new GetMethod();
        try {
            VerifyProductSubscriptionByPidResponse response = this.makeRequest((HttpMethodBase)method, "VerifyProductSubscriptionByPid", params, VerifyProductSubscriptionByPidResponse.class);
            VerifyProductSubscriptionByPidResult result = response.getVerifyProductSubscriptionByPidResult();
            boolean bl = result.isSubscribed();
            return bl;
        }
        catch (JAXBException ex) {
            throw new DevPayException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (HttpException ex) {
            throw new DevPayException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new DevPayException(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public boolean isProductSubscribedByTokens(String productToken, String userToken) throws DevPayException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ProductToken", productToken);
        params.put("UserToken", userToken);
        GetMethod method = new GetMethod();
        try {
            VerifyProductSubscriptionByTokensResponse response = this.makeRequest((HttpMethodBase)method, "VerifyProductSubscriptionByTokens", params, VerifyProductSubscriptionByTokensResponse.class);
            VerifyProductSubscriptionByTokensResult result = response.getVerifyProductSubscriptionByTokensResult();
            boolean bl = result.isSubscribed();
            return bl;
        }
        catch (JAXBException ex) {
            throw new DevPayException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (HttpException ex) {
            throw new DevPayException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new DevPayException(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public String refreshUserToken(String userToken, String additionalTokens) throws DevPayException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("UserToken", userToken);
        if (additionalTokens != null) {
            params.put("AdditionalTokens", additionalTokens);
        }
        GetMethod method = new GetMethod();
        try {
            RefreshUserTokenResponse response = this.makeRequest((HttpMethodBase)method, "RefreshUserToken", params, RefreshUserTokenResponse.class);
            RefreshUserTokenResult result = response.getRefreshUserTokenResult();
            String string = result.getUserToken();
            return string;
        }
        catch (JAXBException ex) {
            throw new DevPayException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (HttpException ex) {
            throw new DevPayException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new DevPayException(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    static void setVersionHeader(AWSQueryConnection connection) {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add("2008-04-28");
        connection.getHeaders().put("Version", vals);
    }
}

